/***************************************************************************
                          dlgprofiletriggersinput.cpp
                      -------------------
    description          :
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kfontdialog.h>
#include <qmessagebox.h>
#include <qregexp.h>
#include "dlgprofiletriggersinput.h"


DlgProfileTriggersInput::DlgProfileTriggersInput(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Triggers"));

	initDialog();
	_font=QFont("fixed");

	slotSetEnablesDisables();

 	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(slotCancelPressed()) );
	connect( font_Button, SIGNAL(clicked()), SLOT(slotFontButtonPressed()) );

	// that's lame, but i wanted to get it working fast
	connect( actionSendCommand_RadioButton, SIGNAL(clicked()), SLOT(slotSetType0()) );
	connect( actionColorString_RadioButton, SIGNAL(clicked()), SLOT(slotSetType1()) );
	connect( actionColorLine_RadioButton, SIGNAL(clicked()), SLOT(slotSetType2()) );

	connect( foreground_CheckBox, SIGNAL(toggled(bool)), SLOT(slotSetEnablesDisables()) );
	connect( background_CheckBox, SIGNAL(toggled(bool)), SLOT(slotSetEnablesDisables()) );
	connect( font_CheckBox, SIGNAL(toggled(bool)), SLOT(slotSetEnablesDisables()) );

}

DlgProfileTriggersInput::~DlgProfileTriggersInput(){
}

void DlgProfileTriggersInput::slotOKPressed(){
	QRegExp re(trigger_LineEdit->text());

	if ((isRegEx_CheckBox->isChecked()==true) && (re.isValid()==false))
	{
		QMessageBox invalidRegEx("Kmud",i18n("The regular expression you entered as a trigger is invalid."),QMessageBox::Warning,
			  						  QMessageBox::Ok | QMessageBox::Default,0,0,0,"InvalidRegExMessageBox",TRUE,0);
		invalidRegEx.exec();			
	}
	else
	{
		accept();
	}
}

void DlgProfileTriggersInput::slotCancelPressed(){
	reject();
}

void DlgProfileTriggersInput::slotFontButtonPressed()
{
	KFontDialog d(this,"TriggerFontDialog",true,NULL);

	d.setFont(_font);

	if (d.exec())
		setFont(d.font());
}

void DlgProfileTriggersInput::slotSetType0()
{
	actionSendCommand_RadioButton->setChecked(true);
	actionColorString_RadioButton->setChecked(false);
	actionColorLine_RadioButton->setChecked(false);
	slotSetEnablesDisables();
}

void DlgProfileTriggersInput::slotSetType1()
{
	actionSendCommand_RadioButton->setChecked(false);
	actionColorString_RadioButton->setChecked(true);
	actionColorLine_RadioButton->setChecked(false);
	slotSetEnablesDisables();
}

void DlgProfileTriggersInput::slotSetType2()
{
	actionSendCommand_RadioButton->setChecked(false);
	actionColorString_RadioButton->setChecked(false);
	actionColorLine_RadioButton->setChecked(true);
	slotSetEnablesDisables();
}


void DlgProfileTriggersInput::slotSetEnablesDisables()
{
	setUpdatesEnabled(false);

	command_LineEdit->setEnabled(false);
	foreground_CheckBox->setEnabled(false);
	foreground_KColorButton->setEnabled(false);
	background_CheckBox->setEnabled(false);
	background_KColorButton->setEnabled(false);
	font_CheckBox->setEnabled(false);
	font_Button->setEnabled(false);

	if (getType()==0)
		command_LineEdit->setEnabled(true);

	if (getType()>0)
	{
		foreground_CheckBox->setEnabled(true);
		if (getSetFgColor())
			foreground_KColorButton->setEnabled(true);
		background_CheckBox->setEnabled(true);
		if (getSetBgColor())
			background_KColorButton->setEnabled(true);
		font_CheckBox->setEnabled(true);
		if (getSetFont())
			font_Button->setEnabled(true);
	}

	setUpdatesEnabled(true);
	repaint();
}


/** returns the Trigger */
QString DlgProfileTriggersInput::getTrigger ()
{
	return trigger_LineEdit->text ();
} // getTrigger


/** returns whether trigger is regular exprssion or not */
bool DlgProfileTriggersInput::getIsRegEx ()
{
	return isRegEx_CheckBox->isChecked();
}


/** returns the type of the Trigger */
int DlgProfileTriggersInput::getType ()
{
	int i=0;
	if (actionSendCommand_RadioButton->isChecked()) i=0;
	if (actionColorString_RadioButton->isChecked()) i=1;
	if (actionColorLine_RadioButton->isChecked()) i=2;
	return i;
} // getType

/** returns the command of the Trigger */
QString DlgProfileTriggersInput::getCommand ()
{
	return command_LineEdit->text ();
} // getCommand

/** returns the set foreground color option of the (Color-)Trigger */
bool DlgProfileTriggersInput::getSetFgColor ()
{
	return foreground_CheckBox->isChecked();
} // getSetFgColor

/** returns the foreground color of the (Color-)Trigger */
QColor DlgProfileTriggersInput::getFgColor ()
{
	return foreground_KColorButton->color();
} // getFgColor

/** returns the set background color option of the (Color-)Trigger */
bool DlgProfileTriggersInput::getSetBgColor ()
{
	return background_CheckBox->isChecked();
} // getSetBgColor

/** returns the background color of the (Color-)Trigger */
QColor DlgProfileTriggersInput::getBgColor ()
{
	return background_KColorButton->color();
} // getBgColor

/** returns the set font option of the (Color-)Trigger */
bool DlgProfileTriggersInput::getSetFont ()
{
	return font_CheckBox->isChecked();
} // getSetFont


/** returns the font of the (Color-)Trigger */
QFont DlgProfileTriggersInput::getFont ()
{
	return _font;
} // getFont




/** set's the name of the trigger */
void DlgProfileTriggersInput::setTrigger (QString Name)
{
	trigger_LineEdit->setText (Name);
} // setTrigger

/** set's whether trigger is regular exprssion or not */
void DlgProfileTriggersInput::setIsRegEx (bool yes)
{
	isRegEx_CheckBox->setChecked(yes);
}


/** set's the type of the trigger */
void DlgProfileTriggersInput::setType (int type)
{
	actionSendCommand_RadioButton->setChecked(false);
	actionColorString_RadioButton->setChecked(false);
	actionColorLine_RadioButton->setChecked(false);

	switch (type)
	{
		case 0: actionSendCommand_RadioButton->setChecked(true); break;
		case 1: actionColorString_RadioButton->setChecked(true); break;
		case 2: actionColorLine_RadioButton->setChecked(true); break;
		default: actionSendCommand_RadioButton->setChecked(true);
	}	
	slotSetEnablesDisables();
} // setType

/** set's the definition of the trigger */
void DlgProfileTriggersInput::setCommand (QString command)
{
	command_LineEdit->setText (command);
} // setCommand

/** set's the set foreground color option of the (color-)trigger */
void DlgProfileTriggersInput::setSetFgColor (bool b)
{
	foreground_CheckBox->setChecked(b);
} // setSetFgColor

/** set's the foreground color of the (color-)trigger */
void DlgProfileTriggersInput::setFgColor (QColor fgc)
{
	foreground_KColorButton->setColor(fgc);
} // setFgColor

/** set's the set background color option of the (color-)trigger */
void DlgProfileTriggersInput::setSetBgColor (bool b)
{
	background_CheckBox->setChecked(b);
} // setSetBgColor

/** set's the background color of the (color-)trigger */
void DlgProfileTriggersInput::setBgColor (QColor bgc)
{
	background_KColorButton->setColor(bgc);
} // setBgColor

/** set's the set font option of the (color-)trigger */
void DlgProfileTriggersInput::setSetFont (bool b)
{
	font_CheckBox->setChecked(b);
} // setSetFont

/** set's the font of the (color-)trigger */
void DlgProfileTriggersInput::setFont (QFont font)
{
	QString s;

	s.setNum(font.pointSize());
	s.prepend(", ");
	s.prepend(font.family());
	font_Button->setFont(font);
	font_Button->setText(s);
	
	_font=font;

} // setFont

