/***************************************************************************
                          matrix.h  -  description
                             -------------------
    begin                : Mon Nov 12 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATRIX_H
#define MATRIX_H


/**
  *@author Jos?Pablo Fern?dez
  */

#include <qarray.h>

#include <iostream.h>        /* Para print */


template<class type>
class Matrix
{
public:
	Matrix()  { }
	Matrix(int rows, int cols) {
		Matrix::rows = rows ;
		Matrix::cols = cols ;
		Matrix::matrix = QArray<type> (rows*cols) ;
	}

	~Matrix() { }
	type get(int i, int j) {
		return matrix[rows*i+j] ;
	}
	void set(int i, int j, type value) {
		matrix[rows*i+j] = value ;
	}
	
	void print() { /* para depuracion */
		int i, j ;
		int v ;
		for (i=0; i<rows; i++) {
			for (j=0; j<cols; j++) {
				v = get(i,j) ;
				if (v == -1) {
					cout << "  " ;
				} else {
					cout  << v << " " ;
				}
			}
			cout << endl ;
		}
	}

	bool isEqual(Matrix matrix2) {
		int i, j ;
		for (i=0; i<rows; i++)
			for (j=0; j< cols; j++)
				if (get(i,j)  != matrix2.get(i,j))
					return (false) ;
		return (true) ;
	}
				

private:
	int rows ;
	int cols ;
	QArray<type> matrix ;
} ;

#endif
