#ifndef KPUZZLE_H 
#define KPUZZLE_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktmainwindow.h>
 
#include "kpuzzlewidget.h"

#include <qpopupmenu.h>
#include <qpixmap.h>

// Menu items to be enabled/disabled
#define MI_NONE 0x0
#define MI_STOP_GAME 0x0001
#define MI_PAUSE 0x0002
#define MI_SHOW_LARGE 0x0004

// How to load images
// Preload all
#define IL_PRELOAD 2
// Keep images when loaded once
#define IL_KEEP 1
// Delete images after use
#define IL_ON_USE 0

class KPuzzle : public KTMainWindow
{
	Q_OBJECT
 public:
	KPuzzle();
	virtual ~KPuzzle();

// Data
 public:
	bool usePieceMask() { return _usePieceMask; } 
	bool turnPiecesAround() { return _turnPiecesAround; }
	int imageLoading() { return _imageLoading; }
	QString& playerName() { return _playerName; }

	KPuzzleWidget* view() { return _view; }

 protected:
	QPopupMenu* _filemenu;
	QPopupMenu* _gamemenu;

 private:
	KPuzzleWidget *_view;

	// Configuration
	bool _usePieceMask; // use piece mask by default?
	bool _turnPiecesAround; // how should a piece be turned?
	int _imageLoading; // how to load images
	QString _playerName; // name of last player

// Implementation
 public:
	void enableMenuItems(int enable);


 protected:
	void saveOptions();
	void readOptions();

 protected slots:
	void slotSetOptions();

};

#endif // KPUZZLE_H 
