#ifndef PICVIEW_H 
#define PICVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>

#include <qpixmap.h>
#include <qevent.h>
#include <qrect.h>
#include <qsize.h>

#define PICVIEW_WIDTH 150.0
#define PICVIEW_HEIGHT 100.0

class CPicview : public QWidget
{
	Q_OBJECT
 public:
	CPicview(QWidget *parent);
	virtual ~CPicview();

// Data
 public:

 protected:
	QSize pixmapSize() { return _pixmap->size(); }
	QSize gamePixmapSize() { return _gamePixmapSize; }
	QRect vRect() { return QRect(_vRectTopLeft,_vRectSize); }
	QPoint translate2GamePixmap(QPoint p);
	QPoint translateFromGamePixmap(QPoint p);
	float scaleX() { return PICVIEW_WIDTH / _gamePixmapSize.width(); }
	float scaleY() { return PICVIEW_HEIGHT / _gamePixmapSize.height(); }

	QPixmap* _pixmap;
	QPoint _vRectTopLeft;
	QSize _vRectSize;
	QSize _gamePixmapSize;

// Implementation
 public:
	void updatePixmap(QPixmap* p,QRect udRect);
	void addPiece(QPixmap* piece,QPoint pos);

 protected:
	virtual void paintEvent(QPaintEvent* e);
	virtual void mouseMoveEvent(QMouseEvent* e);
	virtual void mousePressEvent(QMouseEvent* e);
	virtual void mouseReleaseEvent(QMouseEvent* e);
	
	virtual QPoint DPtoLP(QPoint p);

 public slots:
	void slotChangeViewPos(QPoint pos);

 signals:
        void sigChangeViewPos(QPoint pos);

};

#endif // PICVIEW_H 
