#ifndef PREFS_H 
#define PREFS_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qdialog.h>

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qlayout.h>

class CPrefsDialog : public QDialog
{
	Q_OBJECT
 public:
	CPrefsDialog(QWidget* parent);
	virtual ~CPrefsDialog();

	void setValues(); 
	void retrieveValues();

 public:
	bool _usePieceMask;
	bool _turnPiecesAround;
	int _imageLoading;

 protected:
	QCheckBox* _mask;
	QCheckBox* _turn;
	QButtonGroup* _loading;

	QRadioButton* _ilOnUse;
	QRadioButton* _ilKeep;
	QRadioButton* _ilPreload;

	QVBoxLayout* _elements;
	QHBoxLayout* _buttons;

	QPushButton* _ok;
	QPushButton* _cancel;
};

#endif // PREFS_H 
