/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAMEDIALOG_H
#define GAMEDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdialog.h>

#include <qwidget.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlayout.h>

class CGameDialog : public QDialog
{
        Q_OBJECT
 public:
	CGameDialog(QWidget* parent);
	virtual ~CGameDialog();

	// Data
 public:
	char gameType();
	char pieceSize();
	char difficulty();
	bool useMask() { return _useMask->isChecked(); }

 protected:
        QVBoxLayout* _vbox;
        QHBoxLayout* _hbox;

	QComboBox* _gameType;
	QComboBox* _pieceSize;
	QComboBox* _difficulty;
	QCheckBox* _useMask;

 protected slots:
        void slotHelp();
};

#endif // GAMEDIALOG_H
