/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPUZZLE_H
#define KPUZZLE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>

#include "kpuzzleview.h"

class KPuzzle : public KMainWindow
{
    Q_OBJECT

 public:
    KPuzzle();
    virtual ~KPuzzle();

    /*    void load(const QString& url);*/

 // Data
 public:
    bool usePieceMask() { return _usePieceMask; }
    bool turnPiecesAround() { return _turnPiecesAround; }
    int imageLoading() { return _imageLoading; }
    QString& playerName() { return _playerName; }

 protected:
    bool _usePieceMask; // use piece mask by default?
    bool _turnPiecesAround; // how should a piece be turned?
    int _imageLoading; // how to load images
    QString _playerName; // name of last player

 private:
    KPuzzleView *m_view;


 // Implementation
 public:

 protected:
    void createGUI();

    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);

 private slots:
    void changeStatusbar(const QString& text);

 protected slots:
// Show options dialog
        void slotSetOptions();
        void slotHighscores();
};

#endif // KPUZZLE_H
