/***************************************************************************
                          reception.h  -  description
                             -------------------
    begin                : Mon Apr 17 2000
    copyright            : (C) 2000 by Mickal Marchand
    email                : MikMak@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECEPTION_H
#define RECEPTION_H
#include <qstrlist.h>
#include <sys/stat.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>

#define DATA_PERM S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH
/**Gestion des popups reus
  *@author Mickal Marchand
  */
int lock_reg (int fd, int cmd, int type, off_t offset, int whence, off_t len);
void normalperms(void);
void enhancedperms(void);

class Reception {
public: 
	Reception();
	~Reception();
  void Add_popup (QString message,QString from,QString to,QString ip, int type);
  void Del_popup(int id,int type);
  void Log(QString m,QString o,QString d);
	QStrList persos_mess;
	QStrList groupe_mess;
	QStrList autres_mess;
	QStrList persos_orig;
	QStrList groupe_orig;
	QStrList autres_orig;
	QStrList persos_dest;
	QStrList groupe_dest;
	QStrList autres_dest;
	int nombre_popups_total;
	int nombre_popups_persos;
	int nombre_popups_groupe;
	int nombre_popups_autres;
	int courant_perso;
	int courant_groupe;
	int courant_autres;
	QStrList new_persos;
	QStrList new_groupe;
	QStrList new_autres;
	QStrList ip_persos;
	QStrList ip_groupe;
	QStrList ip_autres;
};
#endif
