/***************************************************************************
                          mylineedit.cpp  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mylineedit.h"

MyLineEdit::MyLineEdit(QWidget *parent, const char *name )
		  : QLineEdit(parent,name)
{
	KDNDDropZone *zone = new KDNDDropZone (this, DndURL);
	connect(zone, SIGNAL(dropAction(KDNDDropZone *)), this, SLOT(receiveDrop(KDNDDropZone *)));
}

MyLineEdit::~MyLineEdit()
{
}

void MyLineEdit::focusInEvent(QFocusEvent *fe)
{
	if ( fe->gotFocus() )
		emit focusIn();
	QLineEdit::focusInEvent(fe);
}

void MyLineEdit::receiveDrop( KDNDDropZone *zone)
{
	if ( zone->getDataType() != DndURL )
		return;
	
	QStrList urllist = zone->getURLList();

	QString url, tmp;
	url.sprintf("%s", urllist.first() );
	tmp = url;
	if ( tmp.left(7) == "http://" ) {
		url.remove(0,7);
	}
	tmp = url;
	if ( tmp.left(6) == "ftp://" ) {
		url.remove(0,6);
	}
	this->setText(url);
}