/***************************************************************************
                          domainconf.cpp  -  description
                             -------------------
    begin                : Tue May 2 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          domainconf.cpp  -  description
                             -------------------
    begin                : Wed Jan 26 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "domainconf.h"

DomainConf::DomainConf(QWidget *parent, const char *name )
		  : QFrame(parent,name)
{
	inExCludeBox = new QButtonGroup(this);
	inExCludeBox->setGeometry(5,30,558,30);

	QFrame *ieFrm1 = new QFrame(inExCludeBox);
	ieFrm1->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	ieFrm1->setGeometry(2,2,276,26);

	QFrame *ieFrm2 = new QFrame(inExCludeBox);
	ieFrm2->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	ieFrm2->setGeometry(278,2,280,26);

	includeBut = new QRadioButton(i18n("Get files only from this domains"), inExCludeBox);
	includeBut->setGeometry(5,5,268,20);
	includeBut->setChecked(true);

	QLabel *domLab = new QLabel(i18n("Enter the domains you want to in- or exclude here:"),this);
	domLab->setGeometry(5,60,500,20);
	domLab->setAlignment(AlignCenter);
	
	int x,y;
	QFont fnt ("helvetica",10, QFont::Normal);
	for ( int i=1 ; i <= 16 ; i++) {
		if ( i <= 8 ) {
			x = 5;
			y = ((i*20)+60);
		} else {
			x = 285;
			y = (((i-9)*20)+80);
		}
		iMulti[i] = new QLineEdit(this);
		iMulti[i]->setFont(fnt);
		iMulti[i]->setGeometry(x,y,276,20);
		QToolTip::add(iMulti[i], i18n("Please enter the domains !\n"
				"Example: www.kpage.de"));
	}

	excludeBut = new QRadioButton(i18n("Don't get files from this domains"), inExCludeBox);
	excludeBut->setGeometry(284,5,270,20);

}

DomainConf::~DomainConf()
{
}

QString DomainConf::whatToInExclude()
{
	QString tmp = 0;
	QString tmp2 = 0;
	for ( int i=1; i <=16; i++) {
		tmp2 = tmp.right(1);
		if (( !tmp.isEmpty() )&&( tmp2 != "," ))
			tmp += ",";
		tmp2 = iMulti[i]->text();
		if ( !tmp2.isEmpty() )
			tmp += tmp2;
	}
	tmp2 = tmp.right(1);
	if ( tmp2 == "," ) {
		uint len = tmp.length();
		tmp.truncate(len+1);
	}
	return tmp;
}