/***************************************************************************
                          scheduleconf.h  -  description
                             -------------------
    begin                : Thu Mar 16 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEDULECONF_H
#define SCHEDULECONF_H

#include <klocale.h>

#include <qwidget.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qframe.h>
#include <qfont.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qstring.h>
#include <qspinbox.h>

/**
  *@author Frank von Daak
  */

class ScheduleConf : public QFrame  {
   Q_OBJECT
public: 
	ScheduleConf(QWidget *parent=0, const char *name=0);
	~ScheduleConf();

private:
	QLabel *dateLab;
	QFrame *monthFrame;
	QButtonGroup *runGrp, *hourlyGrp, *dailyGrp, *dayGrp;
	
public:
	QCheckBox *schedBox, *schedCountBox, *satBut, *sunBut, *monBut, *tueBut,
			  *wedBut, *thuBut, *friBut, *schedOutputBox;
	QSpinBox *schedCountSpBox, *hourSpBox, *minSpBox, *afterHourSpBox,
			 *monthSpBox;
	QRadioButton *hourlyBut, *dailyBut, *weeklyBut, *monthlyBut,
				 *amBut, *pmBut;
	QLabel *dot, *afterHourLab;

private slots:
	void setHourBack(int);
	void setMinuteBack(int);

public slots:
	void enableSched();
	void enableCount();
	void setHourlyOptions();
	void setDailyOptions();
	void setWeeklyOptions();
	void setMonthlyOptions();
};

#endif
