#include <kwvdial.h>
#include <kwvdialdock.h>
#include <kwvdialdock.moc>

KwvdialDock::KwvdialDock(const char *name, Kwvdial *_kwvdial)
	: KSystemTray(NULL, name),
          log("KWvDial",WvLog::Info)
{
    kwvdial = _kwvdial;
    
/* See comments in header file regarding these variables */
    pm1.load("/usr/share/icons/online1.xpm");
    pm2.load("/usr/share/icons/online2.xpm");
    pm3.load("/usr/share/icons/online3.xpm");
    pm4.load("/usr/share/icons/online4.xpm");
    pm5.load("/usr/share/icons/online5.xpm");
    
    popup = new QPopupMenu;
    
    connect(popup,SIGNAL(activated(int)),this,SLOT(dockconnect(int)));
    connect(popup,SIGNAL(aboutToShow()),this,SLOT(fillmenu()));
    
    fillmenu();
    
//    setPixmap(pm1);

    // Dock it by seting the DockWindow to it's ID	
//    KWM::setDockWindow(winId());
    show();
}

KwvdialDock::~KwvdialDock()
{
}

void KwvdialDock::mousePressEvent(QMouseEvent* e)
{
    popup->popup(mapToGlobal(e->pos()));
}

void KwvdialDock::dockdisconnect()
{
    kwvdial->wvdisconnect();
}

void KwvdialDock::dockconnect(int id)
{
    kwvdial->wvconnect(id);
}

void KwvdialDock::killdock()
{
    kwvdial->show();
    log("Undocking...\n");
    delete this;
}

void KwvdialDock::fillmenu()
{
    popup->clear();
    
    WvConf::Iter i(kwvdial->cfg);
    
    for (i.rewind();i.next();)
    {
	QString *temp=new QString(i().name);
	CHECK_PTR(temp);
	popup->insertItem(*temp,-1);
    }
    popup->insertSeparator();
    popup->insertItem("UnDock",this,SLOT(killdock()));
    // How do you "UnDock" a Widget????
    popup->insertItem("Disconnect",this,SLOT(dockdisconnect()));
    popup->insertSeparator();
    popup->insertItem("Quit",kapp,SLOT(quit()));
}
    

/* Here is where there should be some sort of logic as follows create a 32x32 
 * QLabel Object, load online[1-6].xpm, and fall to this loop
 * While (dialer!=NULL) && (dialer->status() == WvDialer::Online) do
 *      display (paint) online1.xpm offline
 *      bitblt it to KwvdialDock::Label
 *      display (paint) online2.xpm
 *      bitblt it to KwvdialDock::Label
 *      display (paint) online3.xpm
 *      bitblt it to KwvdialDock::Label
 *      display (paint) online4.xpm
 *      bitblt it to KwvdialDock::Label
 *      display (paint) online5.xpm
 *      bitblt it to KwvdialDock::Label
 *      display (paint) online6.xpm
 *      bitblt it to KwvdialDock::Label
 * done
 * 
 * 
 * this should display a cute animated icon in the dock bar
 * for completeness it should also:
 * Check for RightMouseButtonClick events, and if there is one, pop up a menu
 * that echo's the "connect" menu on the main KwvDialWidget program, but with
 * a show option that would destroy the DockWidget, and show the KwvDial main
 * widget.
 * Check to make sure that we are still online in the middle of the loop
 * Perhaps display a small timer on the bottom of the window ??? - or at least
 * verify how this is going to work with the timer in the main KwvDial widget.
 */
