/***************************************************************************
                          kexpreferences.cpp  -  description
                             -------------------
    begin                : Tue Mar 12 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include <qvbox.h>
#include <qhgroupbox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>

#include <klocale.h>

#include "kexchange.h"
#include "kexpreferences.h"

KExPreferences::KExPreferences(QWidget *parent,const char *name, bool modal )
	:KDialogBase(Plain,i18n("Preferences"),Ok|Apply|Cancel,Cancel,parent,name,modal,true) {
	main=(KexchangeApp*)parent;

	QWidget *page = plainPage();
  setMainWidget(page);
	QVBoxLayout *layout =new QVBoxLayout(page,0,spacingHint());

	QHGroupBox *autoBox =new QHGroupBox(i18n("Exchange rate updates"),page);
	layout->addWidget(autoBox );
	autoUpdate = new QCheckBox(i18n("Automatic updates"),autoBox);
	QToolTip::add( autoUpdate, i18n("Update exchange rates automatically from the net.") );
	QWhatsThis::add( autoUpdate, i18n("When set, exchange rates will be updated automatically after 12 hours.") );

	QHGroupBox *euroBox =new QHGroupBox(i18n("Euro converter"),page);
	layout->addWidget(euroBox );
	euroShow = new QCheckBox(i18n("Display national units of euro"),euroBox);
	QToolTip::add( euroShow, i18n("Display old national currencies for countries that have switched to euro.") );
	QWhatsThis::add( euroShow, i18n("Display old national currencies for countries that have switched to euro.") );
}
KExPreferences::~KExPreferences(){
}
void KExPreferences::reset() {
	autoUpdate->setChecked(main->getUpdate());
	euroShow->setChecked(main->getEuro());	 	
}

bool KExPreferences::update(){
	main->setUpdate(autoUpdate->isChecked());
	main->setEuro(euroShow->isChecked());
	main->slotDataReady();
	return true;
}

void KExPreferences::slotApply(){
	update();
}

void KExPreferences::slotOk(){
	if (update())
		accept();
}
