#ifndef __CLIENTWCLASS
#define __CLIENTWCLASS

class QToolBar;
class QFrame;
class QKeyEvent;
class QPaintEvent;
class QScrollBar;
class QRect;
class MainWidget;
class NetWidget;

//************ class *************
class ClientW : public QFrame
{	Q_OBJECT
public:
	ClientW(MainWidget *, char *file=(char *)NULL);
	ClientW(MainWidget *, int);
	~ClientW();

	NetWidget *net();
	void hide();
	void show(XDeviceNet *);
	void show();

public slots:
	void hScroll(int);
	void vScroll(int);
	void idChanged(int, int);
	void up();
	void netChange(int);

signals:
	void visibleChanged(QRect);
	void chidden(ClientW *);

private:
	void commonConstruct();
	void keyPressEvent(QKeyEvent *);
	void paintEvent(QPaintEvent *);
	void setWidgets();

	int client;

	QScrollBar *hscroll;
	QScrollBar *vscroll;

	QFrame *netframe;
	NetWidget *netwidget;
	MainWidget *mainwidget;
	QToolBar *toolbar;
	QRect logicBase;
	QRect logicPos;
};
#endif
