#ifndef __KPPLOTSERVER__H__
#define __KPPLOTSERVER__H__

#include <qpopupmenu.h>

#include <ktmainwindow.h>

class KPMatrix;
class KSocket;

struct SKPMatrixEntry
{
  int id;
  int nrows, ncols;
  KPMatrix *matrix;
  QString name;
};


class SKPMEList : public QList<SKPMatrixEntry>
{
 protected:
  int compareItems (QCollection::Item a, QCollection::Item b)
    { return ((SKPMatrixEntry *)a)->id < ((SKPMatrixEntry *)b)->id ? -1 :
      ((SKPMatrixEntry *)a)->id > ((SKPMatrixEntry *)b)->id ? 1 : 0; }
};


class KPlotW;
class KPSprite;
class KPS2D;
class KPS2DParametric;
class KPMatrix;
class KPCoords;
class KPCoordsProp;
class KPComm;

class KPlotServer : public KTMainWindow
{
  Q_OBJECT

  //Right now, only KPlotServer needs these
  enum Tool {SelectTool, ZoomTool};  

 public:
  KPlotServer (const char *_socketname, const char *name = 0L);

  
  protected slots:
    void slotQuit ();
    void slotPointStyle(int idstyle);
    void slotConnected ();
    void slotAddText();
    void slotPointSize();
    void slotPlotType (int);
    //    void slotReload ();
    void slotMouseCoords (int, int);
    //    void slotAdd ();
    void slotFrame ();
    //    void slotAddSpline ();
    void slotToolBarToggle (int);
    void slotNewCoords (QRect);
    void slotSpriteDelete (KPSprite *, int);
    void slotSpriteDelete2 ();
    void slotZoomOut();
    void slotCoordsDialog();
    void slotOKCoords();
    void slotApplyCoords();
    void slotCloseCoords();
    void slotAutoCoords();
    void slotAccept (KSocket *);
    void slotMessageWaiting (int);
    void slotAboutBox (int);

 protected:
  KPlotW *plotw;
  KPS2D *plot;
  KPComm *kpcomm;
  QWidget *cancelwid;
  bool canceled;
  QString socketname;

  QPopupMenu *p_rmb, *ptypes, *file, *edit;
  int idprint, idprintdraft, idaddmatrix, idreload;
  int idconnected, idframe, idspline, idptypes, idcoords,
    idautocoords;
  int *stylelookup;
  QStrList filenames;
  /*  struct SSplineRec
    {
      int series;
      int detail;
  };
  QList<SSplineRec> splines;*/
  QList<KPCoords> zoomout;

  KPS2D *createPlot (KPMatrix *, int plottype=-1);
  void niceCaption (void);
  void setCoords (const KPCoords &);
  void updateMenusEtc (void);
  void axesRMB (KPS2D *p);
  /**
   * Create a spline on (KPS2DParametric *)plot for <i>series</i>
   *  with <i>detail</i>.
   **/
  //  void spline (int series, int detail);

  //  virtual void mousePressEvent (QMouseEvent *);
  virtual void keyPressEvent (QKeyEvent *);

  void startServer (void);

  ~KPlotServer();

 private:
  //Reload info
  bool inreload;
  bool rlconnected;
  double rlpointsize;
  int rlpointstyle;
  QString dirpath;

  QDialog *coordsdlg;
  KPCoordsProp *coordsp;

  KPSprite *todel;

  QCursor *zoomcursor;
  Tool tool;

  SKPMEList matrices;

};

#endif
