
#include <qpushbutton.h>
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "kplotserver.h"

int main (int argc, char *argv[])
{
  KApplication *a = new KApplication (argc, argv, "kplotserver");
  
  if (argc<1)
    {
      KMessageBox::
	sorry (0, i18n("You must specify a socket name as the first "
		       "argument.\nKPlotServer is not meant to be started "
		       "via the command line."),
	       i18n("No socket name -- kplotserver"));
      exit (1);
    }

    KPlotServer *kplotserver = new KPlotServer (argv[1]);



  a->setMainWidget (kplotserver);
  kplotserver->show();

  a->exec();
  
}

