#ifndef __KPSAXIS_H__
#define __KPSAXIS_H__

#include "kpview.h"
#include "kpsprite.h"
#include "kpcoords.h"

class KPS2D;

class KPSAxis : public KPSprite
{
  Q_OBJECT

  friend KPS2D;

 public:
  enum Axis {X, Y};

  /**
   * Create an axis (X or Y).
   **/
  KPSAxis (KPView *view, KPCoords *coords, 
	   Axis, int z=0);

  /**
   * Installs the default RMB menu.
   **/
  void installDefaultRMBMenu (void);    
  
  /**
   * (reimplemented) Sets crossx, crossy now.
   **/
  virtual void moveTo (int x, int y);


  //  void virtual moveBy (int x, int y);

  /**
   * width of the axis is pixels
   **/
  int width (void) {return brect.width();}

  /**
   * height of the axis is pixels
   **/
  int height (void) {return brect.height();}

  /**
   * extensions to X axis width (text overspill) 
   * or Y axis height  in pixels
   * (actually, half of that number)
   **/
  int overSpill (void) 
    { if (axis==X) return tickxw; 
    else return tickyh; }



  /**
   * Recompute *size and tick?? variables.
   * (used by kps2d::resizeEvent())
   **/
  void computeSizes(void);


 protected:
  virtual void draw(QPainter&);
  virtual void setRect();
  QFont tickfont;
  int tickxw, tickxh;
  int tickyw, tickyh;
  double pointsize0;
  Axis axis;
  KPCoords *kcoords;

  virtual void resizeEvent (QResizeEvent *);
  void computeTextSize(void);

  /**
   * The next (and maybe current) height (widhth) of the 
   *  X (Y) axis.
   **/
  int girth () { return igirth; }

  protected slots:
    void slotCoords();

 private:
  double axissize0, bboxsize0, ticksize0; // a percentage
  int axissize, bboxsize, ticksize;
  int decplaces; //# decimal places for labels
  
  int igirth;

  bool blabels, bticks;

};

#endif
