#include <stdio.h>

#include <qglobal.h>

#include "kpspline.h"



#define FZ (double)0
#define F1 (double)1
#define F2 (double)2
#define F3 (double)3
#define F6 (double)6             

#define evalf(f0,f1, g0,g1, z,z1, dx) \
   f0 * z1*z1 * (F3-F2*z1) + f1 * z*z * (F3-F2*z) \
   + (g0*z1 - g1*z) * z * z1 * dx
#define evalg(f0,f1, g0,g1, z,z1, dx) \
   (F6*z*z1*(f1-f0)/dx + g0*z1*(F3*z1-F2) + g1*z*(F3*z-F2))
#define evals(f0,f1, g0,g1, z,z1, dx) \
   ((F6*(f1-f0)*(z1-z)/dx -g0*(F6*z1-F2) + g1*(F6*z-F2)))/dx
 
#define value4(a,b,c,d,dx) a*dx*dx*dx + b*dx*dx + c*dx + d
#define deriv4(a,b,c,d,dx) F3*a*dx*dx + F2*b*dx + c               




KPSpline::KPSpline (KPMatrix *_matrix, unsigned int _detail) :
  KPMatrix (2)
{
  bok = FALSE;
  splinetype = crudespline = 0;
  detail = _detail;

  int ni;

  parameterize = 3;//param;
  if (_matrix->nRows() <= 2)
    return;
  if (splinetype<0 || splinetype>1)
    splinetype=1;
  ns = _matrix->nRows();
  ni = parameterize ? 5 : 3;

  //  x = _matrix->matrix();
  x = new double [ni*ns];
  if (x)
    {
      f = x+ns;
      g = f+ns;
      u = g + ns;
      t = u + ns;
      bok = TRUE;
    }
  else
    return;

  inmat = _matrix;

  if (!generateMatrix ())
    bok=FALSE;

}


KPSpline::~KPSpline (void)
{}

bool
KPSpline::generateMatrix (void)
{
  int i;
  for (i=0;i<(signed)inmat->nRows();i++)
    add (i, inmat->at (i,0),
	 inmat->at (i,1));

  fit ();

  int j=0;
  double z, dz=1./detail, x, y;
  int pt, pend = inmat->nRows()-1;
  for (pt=0; pt<pend; pt++)
    for (i=0, z=0; z<1; z+=dz, i++, j++)
      {
	if (!eval (pt, z, &x, &y, (z==0)))
	  return FALSE;

	set (j, 0, x);
	set (j, 1, y);
      }

  set (j, 0, inmat->at(pt,0));
  set (j, 1, inmat->at(pt,1));

  return TRUE;
}


void
KPSpline::add (int i, double xi, double yi)
{
  double dx;
  static double dx0;
  static int inited=0;
 
  if (i >= ns)
    return;
  *(x + i)   = xi;
  *(f + i)   = yi;
  if (parameterize)
    *(t + i) = (double)i;
  if (i>0 && !parameterize)
    {
      dx = *(x+i) - *(x+i-1);
      if (i==1) dx0 = dx;
      else if (dx*dx0 <= (double)0)
        {
          if (!inited)
            {
              printf("Function not single valued.  Solving for"
		     "spline on %d out of %d points\n", i, ns);
              inited=1;
            }
          ns = i;
        }
    }
  crudespline = (ns<4) ? 1 : splinetype;                   
}


void
KPSpline::fit (void)
{
  if (crudespline)
    return;
  if (ns==3)
    {
      bok=FALSE;
      return;
    }

  if (!parameterize)
    fit1(x, f, g);
  else
    {
      fit1(t, x, u);
      fit1(t, f, g);
    }                  
}

void
KPSpline::fit1 (double *x,  double *f, double *g)
{
  int i, ni;
  double *z, *u11, *delta, l, d;
 
  ni = ns - 1;                                  /* nb intervals */
 
  g[0]  = fourfit(x,      f,      0);           /* g on ends from 4-fit */
  g[ni] = fourfit(x+ni-3, f+ni-3, 1);
 
  //  u11 = (double *)calloc(2*ni, sizeof(double));   /* allocate work array */
  u11 = new double [2*ni];
  if (u11==0)
    {
      bok=FALSE;
      return;
    }
  delta = u11+ni;                               /* work array assignments */
  z = g;
 
  for(i=0; i<ni; i++)                           /* (data is 0...ni) */
    {
      d = x[i+1] - x[i];
      delta[i] = F1 / d;
    }
 
  for(i=1; i<ni; i++)
    {
      z[i] = (f[i+1] - f[i]) * delta[i] * delta[i] +
             (f[i] - f[i-1]) * delta[i-1] * delta[i-1];
      z[i] *= F3;
      if (i==1)    z[i] -= g[0] * delta[i-1];
      if (i==ni-1) z[i] -= g[ni] * delta[i];
      u11[i] = F2 * (delta[i] + delta[i-1]);
      if (i > 1)
        {
          l = delta[i-1] / u11[i-1];
          z[i] -= l * z[i-1];
          u11[i] -= l * delta[i-1];
        }
    }
 
  g[ni-1] = z[ni-1] / u11[ni-1];
  for (i=ni-2; i>0; i--)
    g[i] = (z[i] - g[i+1]*delta[i]) / u11[i];
 
  delete u11;
}                                    


/*----------------------------------------------------------------------------
|       fourfit
|       * IN:  x, f = pointers to 1st of 4 points; dx = offset to calculate p
|       * OUT: the derivitive at the desired point
----------------------------------------------------------------------------*/
double
KPSpline::fourfit(double *x, double *f, int right)
{
  double a, b, c, d, dx, gi; //,fi

  getcoeff(x+1, f+1, &a, &b, &c, &d);
  dx = right ? *(x+3) : *x;
  dx -= *(x+1);
  /* fi = value4(a,b,c,d,dx)*/ ;                /* DEBUG! */
  gi = deriv4(a,b,c,d,dx);
  return gi;
}


 
/*----------------------------------------------------------------------------
|       getcoeff
|       *   f = a x**3 + bx**2 + cx + d
|       *   IN: x, f = pointer to the 2nd of 4 points
----------------------------------------------------------------------------*/
void
KPSpline::getcoeff(double *x, double *f,
		   double *a, double *b, double *c, double *d)
{
  double M[9], B[9], det, x0, f0, *p, dx;
  static int which=0;
  int i, i0, j;
#define Det(B)  (B[0]*B[4]*B[8] + B[1]*B[5]*B[6] + B[2]*B[3]*B[7] - \
                 B[2]*B[4]*B[6] - B[5]*B[7]*B[0] - B[8]*B[3]*B[1])
 
  x0 = *x;
  f0 = *d = *f;
  for(i=0; i<9; i+=3)
    {
      j = (i==0) ? -1 : i/3;
      dx = *(x+j) - x0;
      M[i+0] = dx*dx*dx; M[i+1] = dx*dx; M[i+2] = dx;
    }
  det = Det(M);
  for(i0=0; i0<3; i0++)
    {
      for(i=0; i<9; i++) B[i] = M[i];
      B[i0+0] = *(f-1) - f0;
      B[i0+3] = *(f+1) - f0;
      B[i0+6] = *(f+2) - f0;
      p=a; if (i0==1) p=b; else if (i0==2) p=c;
      *p = Det(B) / det;
    }
  /*printf("%s: %g %g %g %g --> %g %g %g %g\n", (which==0)?"X":"Y",
         *(x-1), *x, *(x+1), *(x+2), *a, *b, *c, *d);*/
  which = which ? 0 : 1;
}

 
void
KPSpline::getcoeff2(double *x, double *f, double *by, double *cy)
{
  double dx0, dx1, det;
  dx0 = x[0] - x[1];
  dx1 = x[2] - x[1];
  det = dx0*dx0 * dx1 - dx1*dx1 * dx0;
  *by = ( (f[0]-f[1])*dx1 - (f[2]-f[1])*dx0 ) / det;
  *cy = ( dx0*dx0*(f[2]-f[1]) - dx1*dx1*(f[0]-f[1]) ) / det;
}               



/*----------------------------------------------------------------------------
|       eval
|       * evaluates splines in interval i (i=0..ns-2)
|       * z = fraction of distance from point i to point i+1
|       * crudespline: 0=use all, 1=4-fit, 2=p's from 4-fit, 3=p's from f's
----------------------------------------------------------------------------*/
bool
KPSpline::eval (int i, double z, double *xout, double *yout, bool first)
{
  int j;
  static double x0, ax,bx,cx,dx, ay,by,cy,dy;
  double dx0, dt, z1;
 
  if (g==0 || i>=ns-1)
    return FALSE;
 
  z1 = F1 - z;
 
  if (!crudespline && !parameterize)
    {
      dx0 = x[i+1] - x[i];
      *xout = x[i] + z * dx0;
      *yout = evalf(f[i], f[i+1], g[i],g[i+1], z,z1, dx0);
    }
  else if (!crudespline && parameterize)
    {
      dx0 = t[i+1] - t[i];
      *xout = evalf(x[i],x[i+1], u[i], u[i+1], z,z1, dx0);
      *yout = evalf(f[i],f[i+1], g[i], g[i+1], z,z1, dx0);
    }
 
  else                          /* x,y from 4-fit */
    {
      if (first && ns==3 && i==0)
        {
          ax = ay = FZ;
          dx = x[1]; dy = f[1];
          x0 = x[1];
          if (!parameterize) getcoeff2(x, f, &cy,&dy);
          else { getcoeff2(t, x, &cx, &dx); getcoeff2(t, f, &cy, &dy); }
        }
      else if (first && ns>3)
        {
          j = (i==0) ? i+1 : i;                 /* j=index to 2nd of 4 */
          if (i==ns-2) j=i-1;
          x0 = x[j];
          if (!parameterize) getcoeff(x+j, f+j, &ay, &by, &cy, &dy);
          else
            {                   
              getcoeff(t+j, x+j, &ax, &bx, &cx, &dx);
              getcoeff(t+j, f+j, &ay, &by, &cy, &dy);
            }
        }
      if (!parameterize)
        {
          *xout = x[i] + z * (x[i+1] - x[i]);
          dt = *xout - x0;
          *yout = value4(ay,by,cy,dy, dt);
        }
      else
        {
          dt = t[i] + z * (t[i+1] - t[i]);
          *xout = value4(ax,bx,cx,dx, dt);
          *yout = value4(ay,by,cy,cy, dt);
        }
    }
 
  return TRUE;
}
