#include <stdio.h>

#include <qrect.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>

#include "kpstext.moc"
#include "kplineddlg.h"
#include "kfontdialog.h"

KPSText::KPSText (KPView *_view, const char *_text,
		  double _x, double _y, int _z)
  : KPSprite (_view, _x, _y, 0, 0, _z)
{
  //  printf ("KPSText\n");

  qstext = _text;
  flags = 0;

  pointsize = .04;
  int newps = (int) (pointsize * view()->width());
  qfont.setPointSize (newps > 1 ? newps : 1);

  propwid = 0;

  setRect();
}

void
KPSText::setRect()
{
  removeFromChunks();

  QPainter p(&srw);
  p.setFont(qfont);
  brect = p.boundingRect(QRect(x(), y(), 5000, 5000),
			 flags, qstext);
  addToChunks();
}      

void
KPSText::draw (QPainter &painter)
{
  printf ("KPSText::draw  %d %d %d %d  %d\n", x(), y(),brect.width(), brect.height(),	  qfont.pointSize());

  /*  printf ("T  (W) %d %d %d %d\n",
	  painter.window().x(),
	  painter.window().y(),
	  painter.window().width(),
	  painter.window().height());
  */

  painter.setFont(qfont);
  painter.setPen(qcolor);
  painter.drawText(brect, flags, qstext);

  if (selected())
    {
      painter.setPen (DashLine);
      painter.setBrush (NoBrush);
      painter.setRasterOp (NotROP);
      painter.drawRect (brect);
    }
}

void
KPSText::computeSizes (void)
{
  int newps = (int) (pointsize * view()->width());
  qfont.setPointSize (newps > 1 ? newps : 1);

  setRect();
}
void
KPSText::resizeEvent (QResizeEvent *r)
{
  computeSizes();

  KPSprite::resizeEvent  (r);
}

void
KPSText::setText (const QString &_text)
{
  qstext = _text;
  setRect();
  update();
}


void
KPSText::installDefaultRMBMenu (void)
{
  rmbmenu = new QPopupMenu;
  rmbmenu->insertItem ("&Change Text", this, SLOT(slotChangeText()));
  rmbmenu->insertItem ("&Properties", this, SLOT(slotProperties()));

} 

void
KPSText::slotProperties ()
{
  QDialog d (0, 0, TRUE);
  QGridLayout *layout = new QGridLayout (&d, 2, 3, 10);

  KPSTextProp *p= (KPSTextProp *)propWidget (&d);
  layout->addMultiCellWidget (p, 0, 0, 0, 2);
  QPushButton *b = new QPushButton ("OK", &d);
  b->setMinimumSize (b->size());
  b->setMaximumSize (b->size());
  b->setDefault(true);
  connect ( b, SIGNAL (clicked()), 
	    &d, SLOT (accept()) );
  layout->addWidget (b, 1, 1);
  b = new QPushButton ("Cancel", &d);
  b->setMinimumSize (b->size());
  b->setMaximumSize (b->size());
  connect ( b, SIGNAL (clicked()), 
	    &d, SLOT (reject()) );
  layout->addWidget (b, 1, 2);

  if (d.exec())
    {
      setText (p->text());
      setColor (p->color());
      setFont (p->font());
      setSize (p->textSize());
      setUnderline (p->underline());
      computeSizes();
      update();
    }

  delete propwid;
  propwid=0;
}

void
KPSText::slotChangeText ()
{
  KPLinedDlg dlg ("Change Text", "Text:", text(), view());
  if (dlg.exec())
    setText (dlg.text());
}

QWidget *
KPSText::propWidget (QWidget *parent, const char *name)
{
  if (propwid!=0)
    delete propwid;

  propwid = new KPSTextProp (this, parent, name);
  return propwid;
}





/// Properties widget
KPSTextProp::KPSTextProp (KPSText *kt, QWidget *parent, const char *name,
			  WFlags _f) :
  QWidget (parent, name, _f)
{
  QGridLayout *layout = new QGridLayout (this, 4, 3, 10);

  letext = new KLineEdit (this);
  letext->setText (kt->text());
  letext->setMinimumSize (letext->sizeHint());
  layout->addWidget (letext, 0, 1);

  lfont = new QLabel (this, 0, QFrame::Sunken);
  lfont->setText (kt->font().family());
  lfont->setMinimumSize (lfont->sizeHint());
  layout->addWidget (lfont, 1, 1);

  btnfont = new QPushButton ("Change...", this);
  btnfont->setMinimumSize (btnfont->sizeHint());
  connect ( btnfont, SIGNAL (clicked()), 
	    this, SLOT (slotFont()) );
  layout->addWidget (btnfont, 1, 2);
  
  lesize = new KLineEdit (this);
  QString qs;
  qs.setNum (100.*kt->size());
  lesize->setText (qs);
  lesize->setMinimumSize (lesize->sizeHint());
  layout->addWidget (lesize, 2, 1);

  kcb = new KColorButton (kt->color(), this);
  kcb->setColor (kt->color()); //not supposed to need this
  kcb->setMinimumSize (kcb->sizeHint());
  layout->addWidget (kcb, 3, 1);

  kcbund = new QCheckBox ("&Underline", this);
  kcbund->setChecked (kt->underline());
  kcbund->setMinimumSize (kcbund->sizeHint());
  layout->addWidget (kcbund, 3, 2);


  QLabel *label = new QLabel (letext, "&Text:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 0, 0);
  label = new QLabel (lfont, "&Font:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 1, 0);
  label = new QLabel (lesize, "Size:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 2, 0);
  label = new QLabel (btnfont, "&Color:", this);
  label->setMinimumSize (label->sizeHint());
  layout->addWidget (label, 3, 0);

  f = kt->font();
  layout->activate();
}


void
KPSTextProp::slotFont ()
{
  KFontDialog::getFont (f);
}

