/**
 * KPSText
 * A text label sprite
 *
 * @author David Sweet
 **/

#ifndef __KPSTEXT_H__
#define __KPSTEXT_H__

#include <qobject.h>

#include <klined.h>

#include "kpview.h"
#include "kpsprite.h"
#include "kpswhatami.h"

class KPSTextProp;

class KPSText : public KPSprite
{
  Q_OBJECT

 public:
  KPSText (KPView *view, const char *text, double x=0, double y=0, int z=0);

  /**
   * Change the text.
   **/
  void setText (const QString &text);

  /**
   * Get the text.
   **/
  QString text (void) const  { return qstext; }

  /**
   * Change the text color.
   **/
  void setColor (QColor color) {qcolor = color;}

  /**
   * Get the text color.
   **/
  QColor color (void) { return qcolor; }

  /**
   * Change the text font.
   **/
  void setFont (QFont font) { qfont = font; }

  /**
   * Get the text font.
   **/
  QFont font (void) { return qfont; }

  /**
   * Get the text size (not pointsize, but logical size).
   **/
  double size (void) { return pointsize; }
		      
  /**
   * Set the text size (not pointsize, but logical size).
   **/
  void setSize (double s) { pointsize = s; }

  /**
   * Installs the default RMB menu.
   **/
  void installDefaultRMBMenu (void);

  /**
   * This KPSprite offers a properties widget.
   **/
  QWidget *propWidget (QWidget *parent, const char *name=0);

  /**
   * Underline the text.
   **/
  void setUnderline (bool u) { qfont.setUnderline (u); }

  /**
   * Text underlined?
   **/
  bool underline (void) { return qfont.underline(); }


  /**
   * I am a KPSText.
   **/

  virtual int whatami() const { return RTTI_KPSTEXT; }

  public slots:
    void slotChangeText ();
    void slotProperties();

 protected:
  QWidget srw;
  QString qstext;
  QFont qfont;
  QColor qcolor;
  double pointsize;
  KPSTextProp *propwid;

  virtual void draw(QPainter&);
  virtual void setRect();
  virtual void resizeEvent (QResizeEvent *);

  void computeSizes(void);

 private:
  int flags;

};


/**
 * KPSTextProp
 * @author David Sweet
 *
 * @short Properties widget for KPSText
 **/

#include <stdlib.h>

#include <qcheckbox.h>

#include <klined.h>
#include <kcolorbtn.h>

class QLabel;
class QPushButton;

class KPSTextProp : public QWidget
{
  Q_OBJECT 

 public:
  KPSTextProp (KPSText *, QWidget *parent, const char *name=0, WFlags f=0);

  /**
   * Get the text.
   **/
  //  QString text (void) { return letext->text(); }
  const char * text (void) { return letext->text(); }

  /**
   * Get the text size.
   **/
  double textSize (void) { return atof (lesize->text())/100.; }

  /**
   * Get the font.
   **/
  QFont font (void) { return f; }

  /**
   * Get the color.
   **/
  QColor color (void) { return kcb->color(); }

  /**
   * Text underlined?
   **/
  bool underline (void) { return kcbund->isChecked(); }

 protected:
  KLineEdit *letext, *lesize;
  QLabel *lfont;
  QPushButton *btnfont;
  KColorButton *kcb;
  QFont f;
  QCheckBox *kcbund;

  protected slots:
    void slotFont ();
};


#endif
