/***************************************************************************
                          about.cpp  -  description
                             -------------------
    begin                : Wed Dec 29 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>

#include <qframe.h>

#include "about.h"
#include "version.h"

About::About(QWidget *parent, const char *name) : QWidget(parent,name)
{
	QString buffer;

	icons = new KIconLoader();
	
  this->resize(400,100);
  QLabel_1= new QLabel(this);
  QLabel_1->setGeometry(10,15,32,32);
  if(icons) QLabel_1->setPixmap(icons->loadIcon("ksetiwatch", KIcon::Desktop));

  Help = new QPushButton(this);
  Help->setGeometry(48,18,75,25);
  Help->setText(i18n("Help"));
  connect(Help, SIGNAL(clicked()), SLOT(slotShowHelp()) );    									  									

  QLabel_2= new QLabel(this);
  QLabel_2->setGeometry(10,65,120,40);
  if(icons) QLabel_2->setPixmap(icons->loadIcon("MadeWithKDev", KIcon::User));

  info = new QScrollView(this);
  info->setGeometry(130,5,500,100);
	info->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  QLabel_3= new QLabel(this);
	QLabel_3->setAlignment( AlignTop | AlignLeft | WordBreak );
	buffer.sprintf("Ksetiwatch Version %d.%d.%d, written by Gordon Machel (gmachel@users.sourceforge.net).\n\n"
  							"Ksetiwatch monitors multiple SETI@home instances running "
  							"on your computer or in your network. It basically provides the look-and-feel of the popular "
  							"SETIWatch program for Windows95/98/NT, written by "
  							"Mark Loukko (http://members.home.net/mloukko/SETI.html).\n\n"
  							"Ksetiwatch is published under the GNU Public License (GPL).\n\n"
  							"Special thanks for helpful hints and suggestions are given to: Frode Tenneb, "
  							"Christian Srensen, Roeland Th. Jansen, Vladimir Vuksan, Matthew Soffen, "
  							"Stefan Pfeiffer, Hugues Talbot, Jan Knutar, and Pelon.",
  							VERSION_NR, VERSION_MAJOR, VERSION_MINOR);
  QLabel_3->setText(buffer);
  info->addChild(QLabel_3);

}

About::~About()
{
}

void About::resizeEvent(QResizeEvent *e)
{
info->resize(info->width(), this->height()-15);
if(info->height() > 200)
	QLabel_3->resize(info->width()-2*info->frameWidth(), info->height()-2*info->frameWidth());
else
  QLabel_3->resize(info->width()-20, 200);
}

/** Invokes the Help window. */
void About::slotShowHelp()
{
kapp->invokeHTMLHelp("", "");
}
