/***************************************************************************
                          addsetilocdlg.h  -  description
                             -------------------
    begin                : Sat Oct 30 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDSETILOCDLG_H
#define ADDSETILOCDLG_H

#include <kdialog.h>
#include <kcolorbtn.h>

#include <qwidget.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qdir.h>

/**
  *@author Gordon Machel
  */

class AddSetiLocDlg : public KDialog
{
Q_OBJECT

public:
	AddSetiLocDlg(QWidget* parent=0, const char* name=0);
	~AddSetiLocDlg();
	void setDir(QString);
  inline const QString location() {return(QLineEdit_2->text());}
  inline const QString directory() {return(QLineEdit_1->text());}
  inline const QString cmdLineArgs() {return(QLineEdit_4->text());}
  inline const bool startup() {return(QCheckBox_1->isChecked());}
  inline const bool logwu() {return(QCheckBox_2->isChecked());}
  inline const QColor color() {return(KColorButton_1->color());}
  inline void setLocation(const QString& t) {QLineEdit_2->setText(t);}
  inline void setDirectory(const QString& t) {QLineEdit_1->setText(t);}
  inline void setCmdLineArgs(const QString& t) {QLineEdit_4->setText(t);}
  inline void setStartup(const bool s) {QCheckBox_1->setChecked(s);}
  inline void setLogwu(const bool s) {QCheckBox_2->setChecked(s);}
  inline void setColor(const QColor c) {KColorButton_1->setColor(c);}

protected:
	//Generated area. DO NOT EDIT!!!(begin)
	QGroupBox* QGroupBox_1;
	QLineEdit* QLineEdit_1;
	QPushButton* QPushButton_1;
	QLabel* QLabel_1;
	KColorButton* KColorButton_1;
	QLabel* QLabel_2;
	QPushButton* QPushButton_2;
	QPushButton* QPushButton_3;
	QLineEdit* QLineEdit_2;
	QLineEdit* QLineEdit_4;
	QLabel* QLabel_3;
	QLabel* QLabel_4;
	QCheckBox* QCheckBox_1;
	QCheckBox* QCheckBox_2;
	//Generated area. DO NOT EDIT!!!(end)

protected slots:
	void ok();
	void getDir();
	void handleText(const QString& t);

};

#endif







