/***************************************************************************
                          options.cpp  -  description
                             -------------------
    begin                : Tue Nov 23 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>

#include <qtimer.h>

#include "options.h"

extern QTimer *RefreshTimer;
extern int RefreshInterval;
extern bool HMS;
extern bool NEWPEAK_RECORD;
extern bool NEWPEAK_CURRENTWU;
extern bool	MINIMIZETOPANEL;
extern bool DRAWGRID;

Options::Options(QWidget *parent, const char *name ) : QWidget(parent,name)
{
  this->resize(590,150);
  QGroupBox_1= new QGroupBox(this,"NoName");
  QGroupBox_1->setGeometry(10,10,320,60);
  setRefreshInterval(RefreshInterval);

  QSlider_3= new QSlider(1000, 300001, 10000, RefreshInterval,
  												QSlider::Horizontal, this);
  QSlider_3->setGeometry(20,30,300,20);
  QSlider_3->setTickmarks(QSlider::Below);
  connect(QSlider_3, SIGNAL(valueChanged(int)), this, SLOT(setRefreshInterval(int)));

  QCheckBox_1= new QCheckBox(this);
  QCheckBox_1->setGeometry(20,70,300,20);
  QCheckBox_1->setText(i18n("Minimize to Panel?"));
  QCheckBox_1->setChecked(MINIMIZETOPANEL);
  connect(QCheckBox_1, SIGNAL(clicked()), this, SLOT(handlePanel()));

  Grid = new QCheckBox(this);
  Grid->setGeometry(20,90,300,20);
  Grid->setText(i18n("Show Grid in List Views?"));
  Grid->setChecked(DRAWGRID);
  connect(Grid, SIGNAL(clicked()), this, SLOT(handleGrid()));

  TimeFormatGroup = new QButtonGroup(i18n("Time Format:"), this);
  TimeFormatGroup->setGeometry(340,10,130,100);
  connect(TimeFormatGroup, SIGNAL(clicked(int)), this, SLOT(handleTimeFormat(int)));

  TimeFormat[0] = new QRadioButton(TimeFormatGroup);
  TimeFormat[0]->setGeometry(10,30,110,20);
  TimeFormat[0]->setText(i18n("hh:mm:ss"));
  TimeFormat[0]->setChecked(HMS);

  TimeFormat[1] = new QRadioButton(TimeFormatGroup);
  TimeFormat[1]->setGeometry(10,60,110,20);
  TimeFormat[1]->setText(i18n("dd:hh:mm:ss"));
  TimeFormat[1]->setChecked(!HMS);

  NotifyPeakGroup = new QButtonGroup(this);
  NotifyPeakGroup->setGeometry(480,10,160,100);
  NotifyPeakGroup->setTitle(i18n("Report new Peaks:"));
  connect(NotifyPeakGroup, SIGNAL(clicked(int)), this, SLOT(handleNotifyPeak(int)));

  NotifyPeak[0] = new QCheckBox(NotifyPeakGroup);
  NotifyPeak[0]->setGeometry(10,30,140,20);
  NotifyPeak[0]->setText(i18n("yes, record peaks"));
  NotifyPeak[0]->setChecked(NEWPEAK_RECORD);

  NotifyPeak[1] = new QCheckBox(NotifyPeakGroup);
  NotifyPeak[1]->setGeometry(10,60,140,20);
  NotifyPeak[1]->setText(i18n("found in current WU"));
  NotifyPeak[1]->setChecked(NEWPEAK_CURRENTWU);
  NotifyPeak[1]->setEnabled(NEWPEAK_RECORD);
}

Options::~Options()
{
}

void Options::handleTimeFormat(int id)
{
	HMS = (id == 0) ? true : false;
}

void Options::handleNotifyPeak(int id)
{
	switch(id)
		{
		case 0: NEWPEAK_RECORD = NotifyPeak[0]->isChecked();
						NotifyPeak[1]->setEnabled(NEWPEAK_RECORD);
						break;
		case 1: NEWPEAK_CURRENTWU = NotifyPeak[1]->isChecked();
						break;
		}
}

void Options::handlePanel()
{
MINIMIZETOPANEL = QCheckBox_1->isChecked();
emit dockStatusChanged();
}

void Options::handleGrid()
{
DRAWGRID = Grid->isChecked();
}

void Options::setRefreshInterval(int ri)
{
QString title, buf;
int m, s;

	if(ri != RefreshInterval) RefreshTimer->changeInterval(RefreshInterval);
	RefreshInterval = ri;
  title = (const char *)i18n("Refresh Interval: ");
  m = (int)(ri/60000);
  s = (ri/1000) % 60;
  if(m)
  	{
  	buf.sprintf("%d min ", m);
  	title += buf;
  	}
  if(s)
  	{
  	if(m)
  		buf.sprintf("%02d s", s);
  	else
  		buf.sprintf("%d s", s);
  	title += buf;
  	}
  QGroupBox_1->setTitle(title);	
}

