/***************************************************************************
                          dockwidget.h  -  description
                             -------------------
    begin                : Sun Nov 28 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H

#include <ksystemtray.h>
#include <kiconloader.h>

#include <qwidget.h>
#include <qpixmap.h>

#include <setiloc.h>
/**
  *@author Gordon Machel
  */

class DockWidget : public KSystemTray
{
   Q_OBJECT
public: 
	DockWidget(QWidget *parent=0, const char *name=0);
	~DockWidget();
  const bool isDocked() {return docked;}

public slots:
  void dock(SetiLoc* loc=0);
  void undock();
  /** Repaints the dock widget with settings of the new location. */
  void updateDockWidget(SetiLoc* loc);

protected:
  void paintEvent(QPaintEvent *e);
  bool docked;
  /**  */
  virtual void timerEvent(QTimerEvent* e);

private slots:		
	void handlePopupCommand(int id);
  /**
   * Enables, disables or changes the popup menu entries before the menu
   * is shown.
   */
  void preparePopupMenu();
  void paintIcon(int st, int ls);
  /** Handles blinking of icon. */
  void slotBlinkIcon();
  /**  */
  void updateProgress();
  /**  */
  void updateState(int st, int ls);

private:
	SetiLoc* location;
  int newID;
	KIconLoader* dockIcons;
	QPixmap mini_seti;
	QPixmap mini_setigrey;
	QPixmap mini_setistopped;
	QPixmap mini_setifinished;
	QPixmap mini_setiloading;
  QPixmap picsmall_pixmap;
  bool showIcon;
  enum popupIDs {StartClient, StopClient};
};

#endif
