/***************************************************************************
                          pulseplot.h  -  description
                             -------------------
    begin                : Mon Oct 23 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PULSEPLOT_H
#define PULSEPLOT_H

#include <setigraph.h>

/**
  *@author Gordon Machel
  */

class PulsePlot : public SetiGraph
{
   Q_OBJECT

public:
	PulsePlot(SetiLoc* loc, QWidget *parent=0, const char *name=0);
	~PulsePlot();

protected: // Protected attributes
  /** Stores the S@h location. */
  SetiLoc* location;
  /** This array stores the pulse data (twice). */
  QArray<double> pulseData;
  /** A pointer to a structure containing the top scores of the location. */
  PulseScore pulse;

protected: // Protected methods

protected slots: // Protected slots
  /** Updates the widget with new pulse data. */
  void showNewPulseData(PulseScore score);
};

#endif
