/***************************************************************************
                          setigraph.h  -  description
                             -------------------
    begin                : Thu Oct 19 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETIGRAPH_H
#define SETIGRAPH_H

#include <qwidget.h>
#include <qarray.h>

#include "setiloc.h"

class KPopupMenu;
class QPopupMenu;

/**
  * This is a generic widget class for displaying graphs for gaussians,
  * pulses, and triplets.

  * @author Gordon Machel
  */

class SetiGraph : public QWidget
{
Q_OBJECT

public:
	SetiGraph(SetiLoc* loc, bool shwPop, bool allowModes, QWidget *parent=0, const char *name=0);
	~SetiGraph();
	enum modeIds {Bars, Lines, Markers, MarkersAndLines};
  /** Draws a curve.
    * @param d The curve data.
    * @param mode The drawing mode: choose from Bars, Lines, Markers, or MarkersAndLines.
    * @param c The color of the curve.
    * @param p A pointer to an open QPainter.
    */
  void drawCurve(const QArray<double>& d, int mode, const QColor& c, QPainter* p);
  /** Sets the info text shown either in the top-left or top-right corner.
    * @param info The info string.
    */
  void setInfoText(const QString& info);
  /** Sets the internal curve data.
    * @param data A QArray with the curve data.
    */
  void setCurve(const QArray<double>& dat);
  /** Sets the internal curve data.
    * @param data An array of doubles with the curve data.
    * @param len The length of the array.
    */
  void setCurve(const double* dat, int len);
  /** Sets the position of the info text: either @e TopRight or @e TopLeft. */
  enum TextPosIds {TopLeft, TopRight};
  void setTextPosition(int pos);
  /** Sets the plot mode (Bars, Lines, Markers, MarkersAndLines). */
  void setPlotMode(int mode);
  /** Sets the range of the y axis by a scale factor. The y range is automatically
    * determined by the max value of the data set. Setting the scale to 1.2 increases
    * the range by 20 %, a scale of 2.0 doubles the range (default is 1.05).
    * @param The scale factor applied to the y axis.
    */
  void setYScale(double scale);
  /** Returns the maximum value of the data array. */
  double maximumValue();
  /** Returns the size of the data array. */
  int arraySize();
  /**  */
  double yScale();

protected:
  /** stores the S@h location */
  SetiLoc* location;
  bool     showPopup;
  bool     allowModeSel;
  /** the right-click popup menu for the Gaussian widget */
  enum PopupIds {BarChart, ScatterChart, Style, ShowInfo, TextPosition, SaveGraph};
  KPopupMenu* gp_options;
  QPopupMenu* info_pos;
  QPopupMenu* marker_lines;
  /** either 0 for bar chart or 1 for scatter chart */
  int plot_mode;
  bool show_info;
  bool marker;
  bool lines;
  /** 0 for top-left or 1 for top-right */
  int text_pos;
  /** the data array */
  QArray<double> data;
  /** maximum value of the data */
  double dataMax;
  /** the y axis scale factor */
  double yscale;
  /** holds the info text */
  QString infoText;

  /** Repaints this widget. */
  virtual void paintEvent(QPaintEvent* e);
  /** Reimplemented for right-mouse-button popup menu. */
  virtual void mousePressEvent(QMouseEvent* e);
  /** Prints info about WU. */
  void printInfo(const QString& info, QPainter* p);
  /**
    * Scans an array of doubles for the maximum value.
    * @param array a pointer to an array of doubles
    * @param len number of elements in the array
    * @return the maximum value
    */
  double maxValue(const QArray<double>& array) const;

protected slots:
  /**  */
  void handlePopupCommand(int id);
  /** enables or disables popup menu items*/
  void checkPopupStatus();
  /**  */
  void handleInfoPos(int id);
  /**  */
  void handleMarkerLines(int id);

};

#endif
