/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qstrlist.h>
#include <qkeycode.h>
#include <kapp.h>
#include <klocale.h>
#include "misc.h"
#include "cervisiaapp.h"

#include "loglist.h"
#include "loglist.moc"


LogListViewItem::LogListViewItem( QListView *list, QString rev, QString author,
                                  QString date, QString branch, QString comment, QString taglist )
    : QListViewItem(list, rev, author, date+" ", branch, truncateLine(comment), extractOrdinaryTags(taglist))
{
}


QString LogListViewItem::truncateLine(QString s)
{
    int pos;

    s.simplifyWhiteSpace();
    if ( (pos = s.find('\n')) != -1 )
        s = s.left(pos) + "...";

    return s;
}


QString LogListViewItem::extractOrdinaryTags(QString s)
{
    int pos;
    QString res;

    // Note: same translation as in logdlg.cpp
    // This is a hack...
    QString prefix = i18n("\nBranchpoint: ");
    prefix.remove(0, 1);
    while ( (pos = s.find('\n')) != -1 )
        {
            QString line = s.left(pos);
            s.remove(0, pos+1);
            if (line.left(prefix.length()) != prefix)
                {
                    res += ", ";
                    res += line;
                }
        }
    if (!res.isEmpty())
        res.remove(0, 2);
    return res;
}


#if QT_VERSION >= 200
QString LogListViewItem::key(int column, bool) const
#else
const char *LogListViewItem::key(int column, bool) const
#endif
{
    static QString tmp, res;

    if (column != 0)
        return text(column);

    QStrList strlist = splitLine(text(column), '.');

    res = "";
    QStrListIterator it(strlist);
    for (; it.current(); ++it)
	{
	    tmp.sprintf("%5d", QString(it.current()).toInt());
	    res += tmp;
	    res += ".";
	}
    res.truncate(res.length()-1);
    return res;
}


LogListView::LogListView(QWidget *parent, const char *name)
    : QListView(parent, name)
{
    setAllColumnsShowFocus(true);
    setMultiSelection(true);
    setSorting(0, false);
    setSorting(3, false);
    addColumn(i18n("Revision"));
    addColumn(i18n("Author"));
    addColumn(i18n("Date"));
    addColumn(i18n("Branch"));
    addColumn(i18n("Comment"));
    addColumn(i18n("Tags"));
}


void LogListView::addRevision(QString rev, QString author, QString date,
                              QString comment, QString taglist, QString branch)
{
    (void) new LogListViewItem(this, rev, author, date, branch, comment, taglist);
}


void LogListView::setSelectedPair(QString selectionA, QString selectionB)
{
    for ( QListViewItem *item = firstChild(); item;
	  item = item->nextSibling() )
	{
            LogListViewItem *i = static_cast<LogListViewItem*>(item);
            setSelected(i, (selectionA == i->text(0) ||
                            selectionB == i->text(0)) );
        }
}


#if QT_VERSION >= 200
void LogListView::contentsMousePressEvent(QMouseEvent *e)
#else
void LogListView::mousePressEvent(QMouseEvent *e)
#endif
{
    if ( e->button() == LeftButton )
	{
#if QT_VERSION >= 200
            QPoint vp = contentsToViewport(e->pos());
#else
            QPoint vp = e->pos();
#endif
	    LogListViewItem *selItem
                = static_cast<LogListViewItem*>( itemAt(vp) );
            if (selItem)
                emit revisionClicked(selItem->text(0), false);
        }
    else if ( e->button() == MidButton )
        {
#if QT_VERSION >= 200
            QPoint vp = contentsToViewport(e->pos());
#else
            QPoint vp = e->pos();
#endif
            LogListViewItem *selItem
                = static_cast<LogListViewItem*>( itemAt(vp) );
            if (selItem)
                emit revisionClicked(selItem->text(0), true);
	}
}


void LogListView::keyPressEvent(QKeyEvent *e)
{
    switch (e->key()) {
    case Key_A:
        if (currentItem())
            emit revisionClicked(currentItem()->text(0), false);
        break;
        break;
    case Key_B:
        if (currentItem())
            emit revisionClicked(currentItem()->text(0), true);
        break;
    case Key_Backspace:
    case Key_Delete:
    case Key_Down:
    case Key_Up:
    case Key_Home:
    case Key_End:
    case Key_Next:
    case Key_Prior:
        if (e->state() == 0)
            QListView::keyPressEvent(e);
        else
#if QT_VERSION >= 200
            capp->postEvent(this, new QKeyEvent(QEvent::KeyPress, e->key(), e->ascii(), 0));
#else
            capp->postEvent(this, new QKeyEvent(Event_KeyPress, e->key(), e->ascii(), 0));
#endif
        break;
    default:
        // Ignore Key_Enter, Key_Return
        e->ignore();
    }
}


// Local Variables:
// c-basic-offset: 4
// End:
