/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qlayout.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <kapp.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include "misc.h"

#include "mergedlg.h"
#include "mergedlg.moc"


MergeDialog::MergeDialog(QWidget *parent, const char *name)
    : QDialog(parent, name, true)
{
    setCaption(i18n("CVS Merge"));

    QBoxLayout *layout = new QVBoxLayout(this, 10);

    bybranch_button = new QRadioButton(i18n("Merge from &branch:"), this);
    bybranch_button->setChecked(true);
    bybranch_button->setMinimumSize(bybranch_button->sizeHint());
    layout->addWidget(bybranch_button);

    QBoxLayout *branchedit_layout = new QHBoxLayout();
    layout->addLayout(branchedit_layout);
    branch_edit = new QLineEdit(this);
    branch_edit->setFocus();
    QFontMetrics fm(fontMetrics());
    branch_edit->setMinimumSize(fm.width("0")*30, branch_edit->sizeHint().height());
    branchedit_layout->addSpacing(15);
    branchedit_layout->addWidget(branch_edit);
    
    bytags_button = new QRadioButton(i18n("Merge &modifications:"), this);
    bytags_button->setMinimumSize(bytags_button->sizeHint());
    layout->addWidget(bytags_button);

    QBoxLayout *tagsedit_layout = new QHBoxLayout();
    layout->addLayout(tagsedit_layout);
    QLabel *tag1_label = new QLabel(i18n("between tag: "), this);
    tag1_edit = new QLineEdit(this);
    QLabel *tag2_label = new QLabel(i18n("and tag: "), this);
    tag2_edit = new QLineEdit(this);
    tag1_edit->setEnabled(false);
    tag2_edit->setEnabled(false);
    tag1_label->setMinimumSize(tag1_label->sizeHint());
    tag1_edit->setMinimumSize(tag1_edit->sizeHint());
    tag2_label->setMinimumSize(tag2_label->sizeHint());
    tag2_edit->setMinimumSize(tag2_edit->sizeHint());
    tagsedit_layout->addSpacing(15);
    tagsedit_layout->addWidget(tag1_label, 0);
    tagsedit_layout->addWidget(tag1_edit, 2);
    tagsedit_layout->addWidget(tag2_label, 0);
    tagsedit_layout->addWidget(tag2_edit, 2);

    group = new QButtonGroup();
    group->insert(bybranch_button);
    group->insert(bytags_button);
    connect( bybranch_button, SIGNAL(toggled(bool)),
             this, SLOT(toggled()) );
#if 0
    connect( bybranch_button, SIGNAL(toggled(bool)),
             branch_edit, SLOT(setEnabled(bool)) );
    connect( bytags_button, SIGNAL(toggled(bool)),
             tag1_edit, SLOT(setEnabled(bool)) );
    connect( bytags_button, SIGNAL(toggled(bool)),
             tag2_edit, SLOT(setEnabled(bool)) );
#endif

    QFrame *frame = new QFrame(this);
    frame->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    frame->setMinimumHeight(frame->sizeHint().height());
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    QPushButton *ok = buttonbox->addButton(i18n("OK"));
    QPushButton *cancel = buttonbox->addButton(i18n("Cancel"));
    ok->setDefault(true);
    connect( ok, SIGNAL(clicked()), this, SLOT(accept()) );
    connect( cancel, SIGNAL(clicked()), this, SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);

    layout->activate();
    resize(sizeHint());
}


void MergeDialog::toggled()
{
    bool bybranch = bybranch_button->isChecked();
    branch_edit->setEnabled(bybranch);
    tag1_edit->setEnabled(!bybranch);
    tag2_edit->setEnabled(!bybranch);
    if (bybranch)
        branch_edit->setFocus();
    else
        tag1_edit->setFocus();
}


MergeDialog::~MergeDialog()
{
    delete group;
}

// Local Variables:
// c-basic-offset: 4
// End:

    
