/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _MERGEDLG_H_
#define _MERGEDLG_H_

#include <qdialog.h>
#include <qradiobutton.h>
#include <qlineedit.h>

class QButtonGroup;


class MergeDialog : public QDialog
{
    Q_OBJECT

public:
    MergeDialog( QWidget *parent=0, const char *name=0 );
    ~MergeDialog();
    bool byBranch()
        { return bybranch_button->isChecked(); }
    QString branch()
        { return branch_edit->text(); }
    QString tag1()
        { return tag1_edit->text(); }
    QString tag2()
        { return tag2_edit->text(); }

private slots:
    void toggled();
    
private:
    QRadioButton *bybranch_button, *bytags_button;
    QLineEdit *branch_edit, *tag1_edit, *tag2_edit;
    QButtonGroup *group;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
