/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef KBABELPREF_H
#define KBABELPREF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

#define PAGE_IDENTITY 0
#define PAGE_EDITOR   1
#define PAGE_SEARCH   2
#define PAGE_SAVE 3
#define PAGE_CATMAN 4


class SavePreferences;
class IdentityPreferences;
class EditorPreferences;
class SearchPreferences;
class CatManPreferences;

#include "settings.h"

class KBabelPreferences : public KDialogBase
{
    Q_OBJECT
public:
    KBabelPreferences(SearchSettings,EditorSettings,SaveSettings,IdentitySettings,CatManSettings);

public slots:
    void updateSaveSettings(SaveSettings);
    void updateIdentitySettings(IdentitySettings);
    void updateCatManSettings(CatManSettings);
    void updateSearchSettings(SearchSettings);

signals:
    void identityOptionsChanged(IdentitySettings);
    void saveOptionsChanged(SaveSettings);
    void editorOptionsChanged(EditorSettings);
    void searchOptionsChanged(SearchSettings);
    void catManOptionsChanged(CatManSettings);

protected slots:
   virtual void slotHelp();
   virtual void slotDefault();
   virtual void slotApply();
   virtual void slotOk();
   virtual void slotCancel();


private:
    SavePreferences *_savePage;
    IdentityPreferences* _identityPage;
    EditorPreferences* _editorPage;
    SearchPreferences* _searchPage;
    CatManPreferences* _catManPage;

    SaveSettings _saveSettings;
    IdentitySettings _idSettings;
    EditorSettings _editorSettings;
    SearchSettings _searchSettings;
    CatManSettings _catManSettings;
};


#endif // KBABELPREF_H
