/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef PREFWIDGETS_H
#define PREFWIDGETS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qvbox.h>
#include <ktabctl.h>
#include "settings.h"


class KLineEdit;
class QLineEdit;
class QCheckBox;
class QComboBox;
class QRadioButton;
class CmdEdit;

class SavePreferences : public QVBox
{
   Q_OBJECT
public:
   SavePreferences(QWidget* parent=0);
   SaveSettings settings() const;
   void setSettings(const SaveSettings&);
   void defaults();

   virtual QSize minimumSizeHint () const;
   virtual QSize sizeHint () const;

private:
   QCheckBox* _lastButton;
   QCheckBox* _revisionButton;
   QCheckBox* _languageButton;
   QCheckBox* _charsetButton;
   QCheckBox* _encodingButton;

   QCheckBox* _updateButton;
   QCheckBox* _autoCheckButton;

   QComboBox* _encodingBox;

   QRadioButton* _defaultDateButton;
   QRadioButton* _localDateButton;
   QRadioButton* _customDateButton;
   QLineEdit* _dateFormatEdit;

private slots:
   void customDateActivated(bool on);
};


class IdentityPreferences : public QVBox
{
    Q_OBJECT
public:
    IdentityPreferences(QWidget *parent = 0);
    IdentitySettings settings() const;
    void setSettings(const IdentitySettings&);
    void defaults();

    virtual QSize minimumSizeHint () const;
    virtual QSize sizeHint () const;

private:
   QLineEdit* _nameEdit;
   QLineEdit* _mailEdit;
   QLineEdit* _langEdit;
   QLineEdit* _listEdit;

   QLineEdit* _timezoneEdit;
};


class EditorPreferences : public QVBox
{
    Q_OBJECT
public:
    EditorPreferences(QWidget *parent = 0);
    EditorSettings settings() const;
    void setSettings(const EditorSettings&);
    void defaults();

    virtual QSize minimumSizeHint () const;
    virtual QSize sizeHint () const;

private:
    QCheckBox* _fuzzyButton;
};


class SearchPreferences : public KTabCtl
{
    Q_OBJECT
public:
    SearchPreferences(QWidget *parent = 0);
    virtual ~SearchPreferences();
    SearchSettings settings() const;
    void setSettings(const SearchSettings&);
    void defaults();

    virtual QSize minimumSizeHint () const;
    virtual QSize sizeHint () const;

private:
   QCheckBox* _caseButton;
   QCheckBox* _ignoreAmpButton;
   QCheckBox* _ignoreNewlineButton;
   QCheckBox* _ignoreDotsButton;
   QCheckBox* _ignoreOtherButton;
   QLineEdit* _otherEdit;

   QCheckBox* _exactButton;
   QCheckBox* _containButton;
   QCheckBox* _isContainedButton;

   QLineEdit* _langEdit;


    QCheckBox* _searchButton;

    QRadioButton* _inCatsButton;
    QRadioButton* _inCompendiumButton;
    QRadioButton* _inAuxiliaryButton;

    KLineEdit* _moPathEdit;
    KLineEdit* _compendiumEdit;
    KLineEdit* _auxiliaryEdit;

private slots:
   void browseMO();
   void browseCompendium();
   void browseAuxiliary();

   void exactButtonToggled(bool);
   void containButtonToggled(bool);
   void isContainedButtonToggled(bool);
};

class CatManPreferences : public KTabCtl
{
    Q_OBJECT
public:
    CatManPreferences(QWidget *parent = 0);
    virtual ~CatManPreferences();

    CatManSettings settings() const;
    void setSettings(const CatManSettings&);
    void defaults();

    virtual QSize minimumSizeHint () const;
    virtual QSize sizeHint () const;

private slots:
   void browsePO();
   void browsePOT();

private:
    KLineEdit* _poDirEdit;
    KLineEdit* _potDirEdit;

    QCheckBox* _openWindowButton;

    CmdEdit* _dirCmdEdit;
    CmdEdit* _fileCmdEdit;
    QCheckBox* _killButton;
};

#endif // PREFWIDGETS_H
