/* -------------------------------------------------------------

   actions.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@bigfoot.com>

   This file is distributed under the Artistic License.
   See LICENSE for details.

   -------------------------------------------------------------

   DictComboAction,            special KAction subclasses used
   DictLabelAction,            in the toolbar
   DictButtonAction

 ------------------------------------------------------------- */

#ifndef _ACTIONS_H_
#define _ACTIONS_H_

#include <qguardedptr.h>
#include <qlist.h>
#include <kaction.h>
#include <kglobalsettings.h>

class KComboBox;
class QLabel;
class QPushButton;


class DictComboAction : public KAction
{
  Q_OBJECT

  public:
    DictComboAction( const QString& text, QObject* parent,
                     const char* name, bool editable, bool autoSized );
    ~DictComboAction();

    virtual int plug( QWidget *w, int index = -1 );
    virtual void unplug( QWidget *w );

    QWidget* widget();
    void setFocus();

    QString currentText();
    void setEditText(const QString &s);
    void setCurrentItem(int index);
    void clearEdit();

    void clear();
    void setList(QStringList items);

  signals:
    void activated(int);
    void activated(const QString&);

  private slots:
    void slotComboActivated(int);
    void slotComboActivated(const QString&);

  private:
    QGuardedPtr<KComboBox> m_combo;
    bool m_editable, m_autoSized;
    KGlobalSettings::Completion m_compMode;
};


class DictLabelAction : public KAction
{
  Q_OBJECT

  public:
    DictLabelAction( const QString &text, QObject *parent = 0, const char *name = 0 );
    ~DictLabelAction();

    virtual int plug( QWidget *widget, int index = -1 );
    virtual void unplug( QWidget *widget );

    void setBuddy(QWidget *buddy);

  private:
    QGuardedPtr<QLabel> m_label;

};


class DictButtonAction : public KAction
{
  Q_OBJECT

  public:
    DictButtonAction( const QString& text, QObject* receiver,
                     const char* slot, QObject* parent, const char* name );
    ~DictButtonAction();

    virtual int plug( QWidget *w, int index = -1 );
    virtual void unplug( QWidget *w );

    int widthHint();
    void setWidth(int width);

  private:
    QGuardedPtr<QPushButton> m_button;
};


// DictToolBarPopupAction is a copy of KToolBarPopupAction from kdelibs 2.1
// included to make Kdict compilable with KDE 2.0
/* This file is part of the KDE libraries
    Copyright (C) 1999 Reginald Stadlbauer <reggie@kde.org>
              (C) 1999 Simon Hausmann <hausmann@kde.org>
              (C) 2000 Nicolas Hadacek <haadcek@kde.org>
              (C) 2000 Kurt Granroth <granroth@kde.org>
              (C) 2000 Michael Koch <koch@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

class DictToolBarPopupAction : public KAction
{
  Q_OBJECT
public:
    //Not all constructors - because we need an icon, since this action only makes
    // sense in a toolbar (as well as menubar)
    /**
     * Create a DictToolBarPopupAction, with a text, an icon, an optionnal accelerator,
     * parent and name.
     *
     * @param text The text that will be displayed.
     * @param icon The icon to display.
     * @param accel The corresponding keyboard accelerator (shortcut).
     * @param parent This action's parent.
     * @param name An internal name for this action.
     */
    DictToolBarPopupAction( const QString& text, const QString& icon, int accel = 0,
                         QObject* parent = 0, const char* name = 0 );

    /**
     * Create a DictToolBarPopupAction, with a text, an icon, an accelerator,
     * a slot connected to the action, parent and name.
     *
     * If you do not want or have a keyboard accelerator, set the
     * @p accel param to 0.
     *
     * @param text The text that will be displayed.
     * @param icon The icon to display.
     * @param accel The corresponding keyboard accelerator (shortcut).
     * @param receiver The SLOT's owner.
     * @param slot The SLOT to invoke to execute this action.
     * @param parent This action's parent.
     * @param name An internal name for this action.
     */
    DictToolBarPopupAction( const QString& text, const QString& icon, int accel,
                         const QObject* receiver, const char* slot,
                         QObject* parent = 0, const char* name = 0 );

    virtual ~DictToolBarPopupAction();

    virtual int plug( QWidget *widget, int index = -1 );
    virtual void unplug( QWidget *widget );

    /**
     * The popup menu that is shown when clicking (some time) on the toolbar
     * button. You may want to plug items into it on creation, or connect to
     * aboutToShow for a more dynamic menu.
     */
    KPopupMenu *popupMenu();

    /**
     * Returns true if this action creates a delayed popup menu
     * when plugged in a KToolbar.
     */
    bool delayed() const;
    /**
     * If set to true, this action will create a delayed popup menu
     * when plugged in a KToolbar. Otherwise it creates a normal popup.
     * Default: delayed.
     */
    void setDelayed(bool delayed);
    /**
     * Returns true if this action creates a sticky popup menu.
     * See @ref setStickyMenu.
     */
    bool stickyMenu() const;
    /**
     * If set to true, this action will create a sticky popup menu
     * when plugged in a KToolbar.
     * "Sticky", means it's visible until a selection is made or the mouse is
     * clicked elsewhere. This feature allows you to make a selection without
     * having to press and hold down the mouse while making a selection.
     * Only available if delayed() is true.
     * Default: sticky.
     */
    void setStickyMenu(bool sticky);

private:
    KPopupMenu *m_popup;
    bool m_delayed:1;
    bool m_stickyMenu:1;
    class DictToolBarPopupActionPrivate;
    DictToolBarPopupActionPrivate *d;
};

#endif
