

#include <qpixmap.h>
#include <qlayout.h>
#include <qfileinfo.h>
#include <qdatetime.h>

#include "kfilecoder.h"
#include "PropertiesDialog.h"

// ===========================================================================================================================
PropertiesDialog::PropertiesDialog(QFile *fArchive, int nNbFiles, int nAlgoUsed, QWidget* parent, const char* name):QDialog(parent, name, TRUE, 118784)
{
	setCaption("Archive Properties");
	
	// Copy infos	
	m_fArchive = fArchive;
	m_nNbFiles = nNbFiles;
	m_nAlgoUsed = nAlgoUsed;
	
	m_btnClose = new QPushButton( this, "Close" );
	m_btnClose->setGeometry( 120, 250, 100, 30 );
	m_btnClose->setMinimumSize( 0, 0 );
	m_btnClose->setMaximumSize( 32767, 32767 );
	connect( m_btnClose, SIGNAL(clicked()), SLOT(slotClose()) );
	m_btnClose->setFocusPolicy( QWidget::TabFocus );
	m_btnClose->setBackgroundMode( QWidget::PaletteBackground );
	m_btnClose->setFontPropagation( QWidget::NoChildren );
	m_btnClose->setPalettePropagation( QWidget::NoChildren );
	m_btnClose->setText( "&Close" );
	m_btnClose->setAutoRepeat( FALSE );
	m_btnClose->setAutoResize( FALSE );
	m_btnClose->setToggleButton( FALSE );
	m_btnClose->setDefault( FALSE );
	m_btnClose->setAutoDefault( FALSE );
	m_btnClose->setIsMenuButton( FALSE );

	m_labelName = new QLabel( this, "Label_1" );
	m_labelName->setGeometry( 20, 30, 320, 20 );
	m_labelName->setMinimumSize( 0, 0 );
	m_labelName->setMaximumSize( 32767, 32767 );
	m_labelName->setFocusPolicy( QWidget::NoFocus );
	m_labelName->setBackgroundMode( QWidget::PaletteBackground );
	m_labelName->setFontPropagation( QWidget::NoChildren );
	m_labelName->setPalettePropagation( QWidget::NoChildren );
	m_labelName->setFrameStyle( 0 );
	m_labelName->setLineWidth( 1 );
	m_labelName->setMidLineWidth( 0 );
	m_labelName->QFrame::setMargin( 0 );
	m_labelName->setText( "Name:" );
	m_labelName->setAlignment( 289 );
	m_labelName->setMargin( -1 );

	m_labelPath = new QLabel( this, "Label_2" );
	m_labelPath->setGeometry( 20, 60, 320, 20 );
	m_labelPath->setMinimumSize( 0, 0 );
	m_labelPath->setMaximumSize( 32767, 32767 );
	m_labelPath->setFocusPolicy( QWidget::NoFocus );
	m_labelPath->setBackgroundMode( QWidget::PaletteBackground );
	m_labelPath->setFontPropagation( QWidget::NoChildren );
	m_labelPath->setPalettePropagation( QWidget::NoChildren );
	m_labelPath->setFrameStyle( 0 );
	m_labelPath->setLineWidth( 1 );
	m_labelPath->setMidLineWidth( 0 );
	m_labelPath->QFrame::setMargin( 0 );
	m_labelPath->setText( "Path:" );
	m_labelPath->setAlignment( 289 );
	m_labelPath->setMargin( -1 );

	m_labelSize = new QLabel( this, "Label_3" );
	m_labelSize->setGeometry( 20, 90, 320, 20 );
	m_labelSize->setMinimumSize( 0, 0 );
	m_labelSize->setMaximumSize( 32767, 32767 );
	m_labelSize->setFocusPolicy( QWidget::NoFocus );
	m_labelSize->setBackgroundMode( QWidget::PaletteBackground );
	m_labelSize->setFontPropagation( QWidget::NoChildren );
	m_labelSize->setPalettePropagation( QWidget::NoChildren );
	m_labelSize->setFrameStyle( 0 );
	m_labelSize->setLineWidth( 1 );
	m_labelSize->setMidLineWidth( 0 );
	m_labelSize->QFrame::setMargin( 0 );
	m_labelSize->setText( "Size:" );
	m_labelSize->setAlignment( 289 );
	m_labelSize->setMargin( -1 );

	m_labelNbFiles = new QLabel( this, "Label_4" );
	m_labelNbFiles->setGeometry( 20, 120, 320, 20 );
	m_labelNbFiles->setMinimumSize( 0, 0 );
	m_labelNbFiles->setMaximumSize( 32767, 32767 );
	m_labelNbFiles->setFocusPolicy( QWidget::NoFocus );
	m_labelNbFiles->setBackgroundMode( QWidget::PaletteBackground );
	m_labelNbFiles->setFontPropagation( QWidget::NoChildren );
	m_labelNbFiles->setPalettePropagation( QWidget::NoChildren );
	m_labelNbFiles->setFrameStyle( 0 );
	m_labelNbFiles->setLineWidth( 1 );
	m_labelNbFiles->setMidLineWidth( 0 );
	m_labelNbFiles->QFrame::setMargin( 0 );
	m_labelNbFiles->setText( "Number of files:" );
	m_labelNbFiles->setAlignment( 289 );
	m_labelNbFiles->setMargin( -1 );

	m_labelAlgo = new QLabel( this, "Label_5" );
	m_labelAlgo->setGeometry( 20, 150, 320, 20 );
	m_labelAlgo->setMinimumSize( 0, 0 );
	m_labelAlgo->setMaximumSize( 32767, 32767 );
	m_labelAlgo->setFocusPolicy( QWidget::NoFocus );
	m_labelAlgo->setBackgroundMode( QWidget::PaletteBackground );
	m_labelAlgo->setFontPropagation( QWidget::NoChildren );
	m_labelAlgo->setPalettePropagation( QWidget::NoChildren );
	m_labelAlgo->setFrameStyle( 0 );
	m_labelAlgo->setLineWidth( 1 );
	m_labelAlgo->setMidLineWidth( 0 );
	m_labelAlgo->QFrame::setMargin( 0 );
	m_labelAlgo->setText( "Algorithm used:" );
	m_labelAlgo->setAlignment( 289 );
	m_labelAlgo->setMargin( -1 );

	m_labelDateLastRead = new QLabel( this, "Label_6" );
	m_labelDateLastRead->setGeometry( 20, 180, 320, 20 );
	m_labelDateLastRead->setMinimumSize( 0, 0 );
	m_labelDateLastRead->setMaximumSize( 32767, 32767 );
	m_labelDateLastRead->setFocusPolicy( QWidget::NoFocus );
	m_labelDateLastRead->setBackgroundMode( QWidget::PaletteBackground );
	m_labelDateLastRead->setFontPropagation( QWidget::NoChildren );
	m_labelDateLastRead->setPalettePropagation( QWidget::NoChildren );
	m_labelDateLastRead->setFrameStyle( 0 );
	m_labelDateLastRead->setLineWidth( 1 );
	m_labelDateLastRead->setMidLineWidth( 0 );
	m_labelDateLastRead->QFrame::setMargin( 0 );
	m_labelDateLastRead->setText( "Last read date:" );
	m_labelDateLastRead->setAlignment( 289 );
	m_labelDateLastRead->setMargin( -1 );

	m_labelDateLastWrite = new QLabel( this, "Label_7" );
	m_labelDateLastWrite->setGeometry( 20, 210, 320, 20 );
	m_labelDateLastWrite->setMinimumSize( 0, 0 );
	m_labelDateLastWrite->setMaximumSize( 32767, 32767 );
	m_labelDateLastWrite->setFocusPolicy( QWidget::NoFocus );
	m_labelDateLastWrite->setBackgroundMode( QWidget::PaletteBackground );
	m_labelDateLastWrite->setFontPropagation( QWidget::NoChildren );
	m_labelDateLastWrite->setPalettePropagation( QWidget::NoChildren );
	m_labelDateLastWrite->setFrameStyle( 0 );
	m_labelDateLastWrite->setLineWidth( 1 );
	m_labelDateLastWrite->setMidLineWidth( 0 );
	m_labelDateLastWrite->QFrame::setMargin( 0 );
	m_labelDateLastWrite->setText( "Last write date:" );
	m_labelDateLastWrite->setAlignment( 289 );
	m_labelDateLastWrite->setMargin( -1 );

	resize(350, 300);
	setMinimumSize(350, 300);
	setMaximumSize(500, 300);

	FillPropertiesLabels();
}

// ===========================================================================================================================
PropertiesDialog::~PropertiesDialog()
{
}

// ===========================================================================================================================
void PropertiesDialog::FillPropertiesLabels()
{
	QFileInfo fi(*m_fArchive);
	char szText[128];
	char szAlgo[128];
	QDateTime dt;

	// Name of file
	sprintf (szText, "Name:\t\t\t%s", (const char *) fi.fileName());
	m_labelName -> setText(szText);

	// Path of file
	sprintf (szText, "Path:\t\t\t%s", (const char *) fi.dirPath());
	m_labelPath -> setText(szText);

	// Size of file
	sprintf (szText, "Size:\t\t\t%ld bytes = %ld KB", fi.size(), fi.size() / 1024);
	m_labelSize -> setText(szText);

	// Number of files
	sprintf (szText, "Number of files:\t\t%ld files", m_nNbFiles);
	m_labelNbFiles -> setText(szText);

	// Algorithm used
	switch (m_nAlgoUsed)
	{	case ALGO_ALG1XOR:
			sprintf (szAlgo, "Based on XOR (exclusive OR)");
			break;

		default:
			sprintf (szAlgo, "Unknowm algorithm");
			break;
	}
	sprintf (szText, "Algorithm used:\t\t%s", szAlgo);
	m_labelAlgo -> setText(szText);

	// Last read date
	dt = fi.lastRead();
	sprintf (szText, "Last read date:\t\t%s", (const char *) dt.toString());
	m_labelDateLastRead -> setText(szText);

	// Last write date
	dt = fi.lastModified();
	sprintf (szText, "Last read date:\t\t%s", (const char *) dt.toString());
	m_labelDateLastWrite -> setText(szText);

}

// ===========================================================================================================================
void PropertiesDialog::slotClose()
{	this->done(0);
}









