#include "kfilecoder.h"
#include "PassDialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmsgbox.h>

#include <qwindowdefs.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpushbt.h>

extern KLocale *locale;

// ===========================================================================================================================
PassDialog::PassDialog( QWidget *parent, const char *name):QDialog(parent,name,TRUE)
{
  m_MainWnd = parent;
	*m_szPassword = NULL; // If the program use password and user click cancel

  m_btnOk = new QPushButton("Ok", this);
  CHECK_PTR( m_btnOk );
  m_btnOk -> setGeometry(30,200,100,30);

  m_btnCancel = new QPushButton("Cancel", this);
  CHECK_PTR( m_btnCancel );
  m_btnCancel -> setGeometry(150,200,100,30);

	m_editPass1 = new QLineEdit(this);
  CHECK_PTR( m_editPass1 );
  m_editPass1 -> setGeometry(30,90,200,25);
	m_editPass1 -> setEchoMode(QLineEdit::Password);

	m_editPass2 = new QLineEdit(this);
  CHECK_PTR( m_editPass2 );
  m_editPass2 -> setGeometry(30,130,200,25);
	m_editPass2 -> setEchoMode(QLineEdit::Password);

  m_label = new QLabel(i18n("Please, enter and confirm the password which will be used to encode and decode your data:"), this);
	m_label -> setAlignment( 1313 ); // Word break
  CHECK_PTR( m_label );
  m_label -> setGeometry(30,10,200,50);
	
  connect(m_btnOk,SIGNAL(clicked()),this,SLOT(slotOk()));
  connect(m_btnCancel,SIGNAL(clicked()),this,SLOT(slotCancel()));
}

// ===========================================================================================================================
PassDialog::~PassDialog()
{	delete m_btnOk;
 	delete m_btnCancel;
 	delete m_editPass1;
 	delete m_editPass2;
}

// ===========================================================================================================================
char *PassDialog::GetPassword()
{
	return m_szPassword;
}

// ===========================================================================================================================
void PassDialog::slotOk()
{	char szPassword1[MAX_PASSLEN];
	char szPassword2[MAX_PASSLEN];

	// Rcuprer les deux mots de passe
	sprintf (szPassword1, "%s", m_editPass1 -> text() );
	sprintf (szPassword2, "%s", m_editPass2 -> text() );

	// Check password are not empty
	if (*szPassword1 == '\0' || *szPassword2 == '\0')
	{ KMsgBox::message(m_MainWnd, "KFileCoder", i18n("The password is empty"), KMsgBox::EXCLAMATION, i18n("Cancel"));
   	return ;
	}

	// Check passwords are the same
	if ( strcmp(szPassword1, szPassword2) != 0)
	{ KMsgBox::message(m_MainWnd, "KFileCoder", i18n("The passwords are not identical"), KMsgBox::EXCLAMATION, i18n("Cancel"));
   	return ;
	}

	// Check password len >= 4
	if (strlen(szPassword1) < 4)
	{ KMsgBox::message(m_MainWnd, "KFileCoder", i18n("The lenght of the minimal password is 4 letters"), KMsgBox::EXCLAMATION, i18n("Cancel"));
   	return ;
	}

	sprintf (m_szPassword, "%s", szPassword1);

  this -> done(0);
}

// ===========================================================================================================================
void PassDialog::slotCancel()
{	this->done(-1);
}


















