/***************************************************************************
                          knewprojectdlg.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knewprojectdlg.h"
#include "resource.h"
#include "kfilereplace.h"

#include <qvbox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qwhatsthis.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmultilinedit.h>
#include <qdir.h>
#include <qframe.h>

#include <kseparator.h>
#include <kmessagebox.h>
#include <kcombobox.h>
#include <kconfig.h>
#include <kfiledialog.h>


// ===========================================================================================================================
KNewProjectDlg::KNewProjectDlg(QWidget *parent, KConfig *config, const char *name=0) : QTabDialog(parent,name,true)
{
  // copy data
  m_config = config;
  
  // main dialog
  setCaption(i18n("New replace project"));
  setMinimumSize(450,350);
  resize(500,500);
  setOkButton(QString::null);
  setDefaultButton(i18n("OK"));
  setCancelButton(i18n("Cancel"));
  
  // resize dialog
  setMinimumSize(300, 200);
  resize(400, 300);
  
  // Create pages
  initPage1();
  initPage2();
  initPage3();
  
  setWhatsThis();
  loadComboValues();
  
  // Set default values (date & time)
  m_editSizeMin -> setEnabled(false);
  m_editSizeMax -> setEnabled(false);
  m_editDateMin -> setEnabled(false);
  m_editDateMax -> setEnabled(false);
  
  // Set default values (owner)
  m_editOwnerUser -> setEnabled(false);
  m_editOwnerGroup -> setEnabled(false);
  
  m_comboOwnerUserType -> setEnabled(false);
  m_comboOwnerUserBool -> setEnabled(false);
  m_comboOwnerGroupType -> setEnabled(false);
  m_comboOwnerGroupBool -> setEnabled(false);
  
  
  // slots
  connect(m_btnDir, SIGNAL(clicked()), this, SLOT(slotDir()));
  connect(this, SIGNAL(defaultButtonPressed()), this, SLOT(slotOk()));
  
  connect(m_checkSizeMin,SIGNAL(clicked()),SLOT(slotSizeMinClicked()));
  connect(m_checkSizeMax,SIGNAL(clicked()),SLOT(slotSizeMaxClicked()));
  
  connect(m_checkDateMin,SIGNAL(clicked()),SLOT(slotDateMinClicked()));
  connect(m_checkDateMax,SIGNAL(clicked()),SLOT(slotDateMaxClicked()));
  
  connect(m_checkOwnerUser,SIGNAL(clicked()),SLOT(slotOwnerUserClicked()));
  connect(m_checkOwnerGroup,SIGNAL(clicked()),SLOT(slotOwnerGroupClicked()));
}

// ===========================================================================================================================
KNewProjectDlg::~KNewProjectDlg()
{
}

// ===========================================================================================================================
QString KNewProjectDlg::getDirectory()
{
  return m_comboDirectory -> currentText();
}	

// ===========================================================================================================================
QString KNewProjectDlg::getFilter()
{
  return m_comboFilter -> currentText();
}	

// ===========================================================================================================================
void KNewProjectDlg::slotDir()
{	
  QString strDir;
  
  strDir = KFileDialog::getExistingDirectory(QString::null, this, i18n("Project directory"));
  if (strDir.isEmpty())
    return ;
  
  m_comboDirectory -> setEditText(strDir);
}

// ===========================================================================================================================
void KNewProjectDlg::slotOk()
{
  bool bMinSize, bMaxSize, bMinDate, bMaxDate;
  
  // Check the Search text and the Filter are not empty
  if (getDirectory().isEmpty() || getFilter().isEmpty())
    {	
      KMessageBox::error(this, i18n("You must fill the combo boxes (directory and filter) before continue"));
      return;
    }
  
  // Copy text into variables
  addCurrentStringToCombo();
  saveComboValues();
  
  // ================== SIZE OPTIONS ========================
  getMaxFilesSize(&bMaxSize, &m_nMaxSize);
  getMinFilesSize(&bMinSize, &m_nMinSize);
  
  // ================== DATE OPTIONS ========================
  QString strMinDate, strMaxDate;
  int nDay, nMonth, nYear;
  
  bMinDate = m_checkDateMin -> isChecked();
  bMaxDate = m_checkDateMax -> isChecked();
  strMinDate = m_editDateMin -> text();
  strMaxDate = m_editDateMax -> text();
  
  // ================== OWNER OPTIONS ========================
  bool bOwnerUser, bOwnerGroup;
  bOwnerUser = getBoolOwnerUser();
  bOwnerGroup = getBoolOwnerGroup();
  
  if ((bOwnerUser && m_editOwnerUser->text().isEmpty()) || (bOwnerGroup && m_editOwnerGroup->text().isEmpty()))
    {
      KMessageBox::error(this, i18n("Some edit boxes are empty in the <b>Owner</b> page."));
      return ;
    }	
  
  // =========================================================
  
  // Check all the fields are filled
  if (   (bMaxSize && m_editSizeMax -> text().isEmpty())
	 || (bMinSize && m_editSizeMin -> text().isEmpty())
	 || (bMinDate && m_editDateMin -> text().isEmpty())
	 || (bMaxDate && m_editDateMax -> text().isEmpty()) )
    {
      KMessageBox::error(this, i18n("Some edit boxes are empty"));
      return ;
    }
  
  // Check option "Size Min/Max": check MinSize is not greater than MaxSize
  if (bMaxSize && bMinSize && (m_nMaxSize < m_nMinSize))
    {
      KMessageBox::error(this, i18n("The MINimal size is greater than the MAXimal size."));
      return ;
    }
  
  // Check option "Date Min/Max": check date is valid
  // Check 2 things: * QRegExp ==> valid text (2/2/4)
  //                 * QDate::isValid()
  
  // 1. Check the first Date: DateMin (After...)
  if (bMinDate) // If "DateMin" option in checked
    {	
      if ( !isDateValid(strMinDate.data()))
	{
	  KMessageBox::error(this, i18n("The dates must be in the YYYY/MM/DD format."));
	  return ;
	}
    }
  
  // 2. Check the second Date: DateMax (Before...)
  if (bMaxDate) // If "DateMax" option in checked
    {	
      if ( !isDateValid(strMaxDate.data()))
	{
	  KMessageBox::error(this, i18n("The dates must be in the YYYY/MM/DD format."));
	  return ;
	}
    }
  
  // 3. Convert Strings to QDate		
  if (bMinDate) // If "DateMin" option in checked
    {
      sscanf(strMinDate.data(),"%4d/%2d/%2d",&nYear, &nMonth, &nDay);
      m_qdMinDate.setYMD(nYear, nMonth, nDay);
    }
  
  if (bMaxDate) // If "DateMax" option in checked
    {
      sscanf(strMaxDate.data(),"%4d/%2d/%2d",&nYear, &nMonth, &nDay);
      m_qdMaxDate.setYMD(nYear, nMonth, nDay);
    }
  
  // 4. Check DateMax is not before DateMin
  if (bMinDate && bMaxDate && m_qdMinDate > m_qdMaxDate)
    {
      KMessageBox::error(this, i18n("The MINimal Date is after the MAXimal Date."));
      return ;
    }
  
  accept();
}

// ===========================================================================================================================
void  KNewProjectDlg::initPage1()
{
  QFrame *frame;
  frame = new QFrame(this, "general");
  
  QGridLayout *gbox;
  gbox = new QGridLayout (frame, 2, 2, 0, 10);
  gbox -> setMargin(15);
  
  m_labelDir= new QLabel(frame,"m_labelDir");
  m_labelDir->setText(i18n("Where are the files you want to replace ?"));
  gbox -> addWidget (m_labelDir, 0, 0);
  
  m_comboDirectory = new KComboBox(true, frame, "m_comboDirectory");
  gbox -> addWidget (m_comboDirectory, 1, 0);
  
  m_btnDir = new QPushButton(frame,"m_btnDir");
  m_btnDir -> setText(i18n("Browse..."));
  gbox -> addWidget (m_btnDir, 1, 1);
  
  m_labelFilter = new QLabel(frame,"m_labelType");
  m_labelFilter->setText(i18n("What type of files do you want to replace ? (*, *.txt, kfile*.cpp, ......)"));
  gbox -> addWidget (m_labelFilter, 2, 0);
  
  m_comboFilter = new KComboBox(true, frame, "m_comboFilter");
  gbox -> addWidget (m_comboFilter, 3, 0);	
  
  addTab(frame, i18n("General"));
}

// ===========================================================================================================================
void  KNewProjectDlg::initPage2()
{
  QFrame *frame;
  frame = new QFrame(this, "date&size");
  
  QGridLayout *gbox;
  gbox = new QGridLayout (frame, 2, 3, 0, 10);
  gbox -> setMargin(15);
  
  m_checkSizeMin = new QCheckBox(frame,"checkSizeMin");
  m_checkSizeMin->setText(i18n("MINimal size of files:"));
  gbox -> addWidget (m_checkSizeMin, 0, 0);
  
  m_editSizeMin = new QLineEdit(frame,"editSizeMin");
  gbox -> addWidget (m_editSizeMin, 0, 1);
  
  m_labelKbMin = new QLabel(frame,"labelKbMin");
  m_labelKbMin->setText(i18n("KB"));
  gbox -> addWidget (m_labelKbMin, 0, 2);
  
  m_checkSizeMax = new QCheckBox(frame,"checkSizeMax");
  m_checkSizeMax->setText(i18n("MAXimal size of files:"));
  gbox -> addWidget (m_checkSizeMax, 1, 0);
  
  m_editSizeMax = new QLineEdit(frame,"editSizeMax");
  gbox -> addWidget (m_editSizeMax, 1, 1);
  
  m_labelKbMax = new QLabel(frame,"labelKbMax");
  m_labelKbMax->setText(i18n("KB"));
  gbox -> addWidget (m_labelKbMax, 1, 2);
  
  m_labelDate1 = new QLabel(frame,"labelLastAccess1");
  m_labelDate1->setText(i18n("The last"));
  gbox -> addWidget (m_labelDate1, 2, 0);
  
  m_comboDateRW = new KComboBox(frame,"comboDateRW");
  m_comboDateRW->insertItem(i18n("writing"));
  m_comboDateRW->insertItem(i18n("reading"));
  gbox -> addWidget (m_comboDateRW, 2, 1);
  
  m_labelDate2 = new QLabel(frame,"labelDate2");
  m_labelDate2->setText(i18n("access must be:"));
  gbox -> addWidget (m_labelDate2, 2, 2);
  
  m_checkDateMin = new QCheckBox(frame,"checkDateMin");
  m_checkDateMin->setText(i18n("After the:"));
  gbox -> addWidget (m_checkDateMin, 3, 0);
  
  m_editDateMin = new QLineEdit(frame,"editDateMin");
  m_editDateMin->setText("1999/12/31");
  gbox -> addWidget (m_editDateMin, 3, 1);
  
  m_checkDateMax = new QCheckBox(frame,"checkDateMax");
  m_checkDateMax->setText(i18n("Before the"));
  gbox -> addWidget (m_checkDateMax, 4, 0);
  
  m_editDateMax = new QLineEdit(frame,"editDateMax");
  m_editDateMax->setText("2000/01/31");
  gbox -> addWidget (m_editDateMax, 4, 1);
  
  addTab(frame, i18n("Date / Size"));
}

// ===========================================================================================================================
void KNewProjectDlg::initPage3()
{
  QFrame *frame;
  frame = new QFrame(this, "access rights");
  
  QGridLayout *gbox;
  gbox = new QGridLayout (frame, 2, 4, 0, 10);
  gbox -> setMargin(15);
  
  // Owner used
  m_checkOwnerUser = new QCheckBox(frame,"checkOwnerUser");
  m_checkOwnerUser->setText(i18n("Owner user"));
  gbox -> addWidget (m_checkOwnerUser, 0, 0);
  
  m_comboOwnerUserType = new KComboBox(frame,"comboOwnerUserType");
  m_comboOwnerUserType->insertItem(i18n("name"));
  m_comboOwnerUserType->insertItem(i18n("ID (number)"));
  gbox -> addWidget (m_comboOwnerUserType, 0, 1);
  
  m_comboOwnerUserBool = new KComboBox(frame,"comboOwnerUserBool");
  m_comboOwnerUserBool->insertItem(i18n("must be"));
  m_comboOwnerUserBool->insertItem(i18n("must not be"));
  gbox -> addWidget (m_comboOwnerUserBool, 0, 2);
  
  m_editOwnerUser = new QLineEdit(frame,"editOwnerUser");
  gbox -> addWidget (m_editOwnerUser, 0, 3);
  
  // Owner group
  m_checkOwnerGroup = new QCheckBox(frame,"checkOwnerGroup");
  m_checkOwnerGroup->setText(i18n("Owner group"));
  gbox -> addWidget (m_checkOwnerGroup, 1, 0);
  
  m_comboOwnerGroupType = new KComboBox(frame,"comboOwnerGroupType");
  m_comboOwnerGroupType->insertItem(i18n("name"));
  m_comboOwnerGroupType->insertItem(i18n("ID (number)"));
  gbox -> addWidget (m_comboOwnerGroupType, 1, 1);
  
  m_comboOwnerGroupBool = new KComboBox(frame,"comboOwnerGroupBool");
  m_comboOwnerGroupBool->insertItem(i18n("must be"));
  m_comboOwnerGroupBool->insertItem(i18n("must not be"));
  gbox -> addWidget (m_comboOwnerGroupBool, 1, 2);
  
  m_editOwnerGroup = new QLineEdit(frame,"editOwnerGroup");
  gbox -> addWidget (m_editOwnerGroup, 1, 3);
   
  addTab(frame, i18n("Owner"));
}

// ===========================================================================================================================
void KNewProjectDlg::loadComboValues()
{
  ///////////////////////////////////////////////////////////////////
  // read the m_config file entries
  QString str, strTemp;
  int i;
  int nInserted;
  
  // Combo box informations
  m_config->setGroup("Directories");
  nInserted = 0;
  for(i = 0; i < MAX_STRINGSINCOMBO; i++)
    {
      strTemp.setNum(i+1);
      str = m_config->readEntry(strTemp, "");		
      if (!str.isEmpty())
	{	
	  m_comboDirectory -> insertItem(str);
	  nInserted++;
	}
    }
  if (nInserted == 0) // If no string in m_config file
    m_comboDirectory -> insertItem(QDir::current().path());
  
  m_config->setGroup("Filters");
  nInserted = 0;
  for(i = 0; i < MAX_STRINGSINCOMBO; i++)
    {
      strTemp.setNum(i+1);
      str = m_config->readEntry(strTemp, "");		
      if (!str.isEmpty())
	{
	  m_comboFilter -> insertItem(str);
	  nInserted++;
	}
      
    }
  if (nInserted == 0) // If no string in m_config file
    m_comboFilter -> insertItem("*.htm;*.html;*.xml");
}

// ===========================================================================================================================
void KNewProjectDlg::saveComboValues()
{
  ///////////////////////////////////////////////////////////////////
  // save the m_config file entries
  QString str, strTemp;
  int i;
  
  // Combo box informations
  m_config->setGroup("Directories");
  for(i = 0; i < (int) m_comboDirectory -> count(); i++)
    {
      strTemp.setNum(i+1);
      m_config->writeEntry(strTemp.data(), m_comboDirectory -> text(i));
    }
  
  m_config->setGroup("Filters");
  for(i = 0; i < (int) m_comboFilter -> count(); i++)
    {	
      strTemp.setNum(i+1);
      m_config->writeEntry(strTemp.data(), m_comboFilter -> text(i));
    }
}

// ===========================================================================================================================
void KNewProjectDlg::addCurrentStringToCombo()
{
  // Get strings from combo Boxes and Insert items to Combo boxes
  bool bAlready;
  KComboBox* combo[2] = {m_comboDirectory, m_comboFilter};
  const char *szString[2] = {getDirectory().data(), getFilter().data()};
  
  for (int i=0; i < 2; i++)
    {	
      // Check string is not already in the combo
      bAlready = false;
      for (int j=0; j < combo[i] -> count(); j++)
	{
	  if ( strcmp(szString[i], combo[i] -> text(j)) == 0 )
	    bAlready = true;
	}
      
      if (!bAlready) // Add it
	{
	  if (combo[i] -> count() >= MAX_STRINGSINCOMBO) // If full
	    combo[i] -> removeItem(4);
	  
	  combo[i] -> insertItem(szString[i], 0);
	}
    }
}

// ===========================================================================================================================
void KNewProjectDlg::setWhatsThis()
{
  QWhatsThis::add(m_btnDir, i18n("To select the directory where you want to search or replace files"));
  QWhatsThis::add(m_comboDirectory, i18n("This is the directory where the search or the replace operation will be done."));
  QWhatsThis::add(m_comboFilter, i18n("Fix the filter of the files you want to search. For example, write \"*.htm\" to search or replace "
				      "all web pages. You can put more than an only filter, when using ';'. For example \"*.html;*.txt;*.xml\""));
  
  QWhatsThis::add(m_editSizeMin, i18n("Minimal size of files. For example, if you put 1024 KB, all files which size is less than 1 MB won't be taken"));
  QWhatsThis::add(m_editSizeMax, i18n("Maximal size of files. For example, if you put 2048 KB, all files which size is more than 2 MB won't be taken"));
  QWhatsThis::add(m_editDateMin, i18n("Minimal date of files in YYYY/MM/DD format. For example, if you put 2000/01/31, all files which were "
				      "(modified/read) before the 31 January 2000 won't be taken"));
  QWhatsThis::add(m_editDateMax, i18n("Maximal date of files in YYYY/MM/DD format. For example, if you put 1999/12/31, all files which were "
				      "(modified/read) after the 31 December 1999 won't be taken"));
  QWhatsThis::add(m_comboDateRW, i18n("Select \"Writing\" if you want to use the date of the last modification, or \"reading\" to use the last "
				      "read access to the file"));
}

// ===========================================================================================================================
void KNewProjectDlg::getMaxFilesSize(bool *bChecked, long unsigned int *nMaxSize)
{
  *bChecked = m_checkSizeMax -> isChecked();
  
  if (*bChecked) // If option activated
    *nMaxSize = m_editSizeMax -> text().toULong() * 1024; // KB --> Bytes
  else
    *nMaxSize = 0;
}

// ===========================================================================================================================
void KNewProjectDlg::getMinFilesSize(bool *bChecked, long unsigned int *nMinSize)
{
  *bChecked = m_checkSizeMin -> isChecked();
  
  if (*bChecked) // If option activated
    *nMinSize = m_editSizeMin -> text().toULong() * 1024; // KB --> Bytes
  else
    *nMinSize = 0;
}

// ===========================================================================================================================
void KNewProjectDlg::slotSizeMinClicked()
{
  m_editSizeMin -> setEnabled(m_checkSizeMin -> isChecked() == true);
}

// ===========================================================================================================================
void KNewProjectDlg::slotSizeMaxClicked()
{
  m_editSizeMax -> setEnabled(m_checkSizeMax -> isChecked() == true);
}

// ===========================================================================================================================
void KNewProjectDlg::slotDateMinClicked()
{
  m_editDateMin -> setEnabled(m_checkDateMin -> isChecked() == true);
}

// ===========================================================================================================================
void KNewProjectDlg::slotDateMaxClicked()
{
  m_editDateMax -> setEnabled(m_checkDateMax -> isChecked() == true);
}

// ===========================================================================================================================
void KNewProjectDlg::slotOwnerUserClicked()
{	
  m_editOwnerUser -> setEnabled(m_checkOwnerUser -> isChecked() == true);
  m_comboOwnerUserType -> setEnabled(m_checkOwnerUser -> isChecked() == true);
  m_comboOwnerUserBool -> setEnabled(m_checkOwnerUser -> isChecked() == true);
}

// ===========================================================================================================================
void KNewProjectDlg::slotOwnerGroupClicked()
{
  m_editOwnerGroup -> setEnabled(m_checkOwnerGroup -> isChecked() == true);
  m_comboOwnerGroupType -> setEnabled(m_checkOwnerGroup -> isChecked() == true);
  m_comboOwnerGroupBool -> setEnabled(m_checkOwnerGroup -> isChecked() == true);
}

// ===========================================================================================================================
bool KNewProjectDlg::isDateValid(const char *szDate)
{
  QRegExp qreDate("[0-9][0-9][0-9][0-9][/][0-9][0-9][/][0-9][0-9]");
  int nDay, nMonth, nYear;
  QDate qdDate;
  
  // a. Check the string is not empty, and the lenght is 4+1+2+1+2 = 10
  if (strlen(szDate) != 10)
    return false;
  
  // b. Check the format of the string: YYYY/MM/DD
  if (qreDate.match(szDate) != 0)
    return false;
  
  // c. Check the date is valid (ex: 1999/12/32 is not valid)
  
  // Convert String to QDate
  sscanf(szDate, "%4d/%2d/%2d", &nYear, &nMonth, &nDay);
  qdDate.setYMD(nYear, nMonth, nDay);
  if (! qdDate.isValid() )
    return false;
  
  return true;
}

// ===========================================================================================================================
int KNewProjectDlg::getTypeOfAccess()
{
  return m_comboDateRW -> currentItem();
}

// ===========================================================================================================================
bool KNewProjectDlg::getBoolMinDate()
{
  return m_checkDateMin -> isChecked();
}

// ===========================================================================================================================
bool KNewProjectDlg::getBoolMaxDate()
{
  return m_checkDateMax -> isChecked();
}

// ===========================================================================================================================
bool KNewProjectDlg::getBoolMinSize()
{
  return m_checkSizeMin -> isChecked();
}

// ===========================================================================================================================
bool KNewProjectDlg::getBoolMaxSize()
{
  return m_checkSizeMax -> isChecked();
}

// ===========================================================================================================================
bool KNewProjectDlg::getBoolOwnerUser()
{
  return m_checkOwnerUser -> isChecked();
}

// ===========================================================================================================================
bool KNewProjectDlg::getBoolOwnerGroup()
{
  return m_checkOwnerGroup -> isChecked();
}

// ===========================================================================================================================
bool KNewProjectDlg::getOwnerUserMustBe()
{
  return (m_comboOwnerUserBool -> currentText() == i18n("must be"));
}

// ===========================================================================================================================
bool KNewProjectDlg::getOwnerGroupMustBe()
{
  return (m_comboOwnerGroupBool -> currentText() == i18n("must be"));
}

// ===========================================================================================================================
QString KNewProjectDlg::getOwnerUserValue()
{
  return m_editOwnerUser->text();
}

// ===========================================================================================================================
QString KNewProjectDlg::getOwnerGroupValue()
{
  return m_editOwnerGroup->text();
}

// ===========================================================================================================================
QString KNewProjectDlg::getOwnerUserType()
{
  return m_comboOwnerUserType -> currentText();
}

// ===========================================================================================================================
QString KNewProjectDlg::getOwnerGroupType()
{
  return m_comboOwnerGroupType -> currentText();
}

// ===========================================================================================================================
QDate KNewProjectDlg::getMinDate()
{
  return m_qdMinDate;
}

// ===========================================================================================================================
QDate KNewProjectDlg::getMaxDate()
{
  return m_qdMaxDate;
}

// ===========================================================================================================================
unsigned long int KNewProjectDlg::getMinSize()
{
  return m_nMinSize;
}

// ===========================================================================================================================
unsigned long int KNewProjectDlg::getMaxSize()
{
  return m_nMaxSize;
}

// ===========================================================================================================================
void KNewProjectDlg::setDatas(QString strDir, QString strFilter)
{	
  if (!strDir.isEmpty())
    m_comboDirectory->setEditText(strDir);
  
  if (!strFilter.isEmpty())
    m_comboFilter->setEditText(strFilter);
}

