/***************************************************************************
                          kpropertiesdlg.h  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNEWPROJECTDLG_H
#define KNEWPROJECTDLG_H

#include "kfilereplace.h"
#include "apistruct.h"

#include <qtabdialog.h>
#include <qdatetime.h>
#include <qwhatsthis.h>
#include <qregexp.h>

class KComboBox;
class QPushButton;
class QLabel;
class KConfig;
class QCheckBox;

// ===========================================================================================================================
class KNewProjectDlg : public QTabDialog
{
   Q_OBJECT

public: 
	KNewProjectDlg(QWidget *parent, KConfig *config, const char *name=0);
	~KNewProjectDlg();
	void initPage1();
	void initPage2();
	void initPage3();
	void loadComboValues();
	void saveComboValues();
	void addCurrentStringToCombo();
	void setDatas(QString strDir, QString strFilter);
	void setWhatsThis();
	void getMaxFilesSize(bool *bChecked, long unsigned int *nMaxSize);
	void getMinFilesSize(bool *bChecked, long unsigned int *nMinSize);

private:
	KConfig *m_config;	
	
protected: 
	// General
	QPushButton *m_btnDir;
	QLabel *m_labelDir;
	QLabel *m_labelFilter;
	KComboBox *m_comboDirectory;
	KComboBox *m_comboFilter;
	
	// Data & Time
	QCheckBox *m_checkSizeMin;
	QLineEdit *m_editSizeMin;
	QLabel *m_labelKbMin;
	QCheckBox *m_checkSizeMax;
	QLineEdit *m_editSizeMax;
	QLabel *m_labelKbMax;
	QLabel *m_labelDate1;
	KComboBox *m_comboDateRW;
	QLabel *m_labelDate2;
	QCheckBox *m_checkDateMax;
	QLineEdit *m_editDateMin;
	QCheckBox *m_checkDateMin;
	QLineEdit *m_editDateMax;
	
	// Owner
	QCheckBox *m_checkOwnerUser;
  KComboBox *m_comboOwnerUserType;
  KComboBox *m_comboOwnerUserBool;
  QLineEdit *m_editOwnerUser;
  QCheckBox *m_checkOwnerGroup;
  KComboBox *m_comboOwnerGroupType;
  KComboBox *m_comboOwnerGroupBool;
  QLineEdit *m_editOwnerGroup;
	

protected slots:
	void slotOk();
	void slotDir();
	
	void slotSizeMinClicked();
	void slotSizeMaxClicked();
	void slotDateMinClicked();
	void slotDateMaxClicked();
	
	void slotOwnerUserClicked();
	void slotOwnerGroupClicked();
	
private:
	bool isDateValid(const char *szDate);

public: // retrun results
	QString getDirectory();
	QString getFilter();
	
	int getTypeOfAccess();
	bool getBoolMinDate();
	bool getBoolMaxDate();
	QDate getMinDate();
	QDate getMaxDate();

	bool getBoolMinSize();
	bool getBoolMaxSize();
	unsigned long int getMinSize();
	unsigned long int getMaxSize();
	
	bool getBoolOwnerUser();
	bool getBoolOwnerGroup();

	bool getOwnerUserMustBe();
	bool getOwnerGroupMustBe();
	
	QString getOwnerUserType();
	QString getOwnerGroupType();

	QString getOwnerUserValue();
	QString getOwnerGroupValue();

private:
	QDate m_qdMinDate;
	QDate m_qdMaxDate;
	unsigned long int m_nMinSize;
	unsigned long int m_nMaxSize;
	
};

#endif
