/***************************************************************************
filterview.h  -  description
-------------------
begin                : Sun Mar 19 11:30:14 MET 2000
copyright            : (C) 2000 by Martin Erdtmann
email                : martin.erdtmann@gmx.de
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef FILTERVIEW_H
#define FILTERVIEW_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qcolor.h>

class FilterDoc;

/** The FilterView class provides the view widget for the FilterApp instance.	
* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As FilterView is part of the
* docuement-view model, it needs a reference to the document object connected with it by the FilterApp class to manipulate and display
* the document structure provided by the FilterDoc class.
* 	
* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
* @version KDevelop version 0.4 code generation
*/
class FilterView : public QWidget
{
	Q_OBJECT
public:
    /** Constructor for the main view */
    FilterView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~FilterView();
	
    /** returns a pointer to the document connected to the view instance. Mind that this method requires a FilterApp instance as a parent
	* widget to get to the window document pointer by calling the FilterApp::getDocument() method.
	*
	* @see FilterApp#getDocument
	*/
    FilterDoc *getDocument() const;
	
    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
	
	/** sets the gridcolor */
	void setGridColor(QColor&);
	/** gives back the gridcolor */
	QColor& gridColor();
	
	/** sets the pressurecolor */
	void setPressureColor(QColor&);
	/** gives back the pressurecolor */
	QColor& pressureColor();
	
	/** sets the pressurecolor */
	void setImpedanceColor(QColor&);
	/** gives back the pressurecolor */
	QColor& impedanceColor();
	
	/** sets the pressuresummarycolor */
	void setPressureSummaryColor(QColor&);
	/** gives back the pressuresummarycolor */
	QColor& pressureSummaryColor();
	
	/** sets the impedancesummarycolor */
	void setImpedanceSummaryColor(QColor&);
	/** gives back the impedancesummarycolor */
	QColor& impedanceSummaryColor();
	
	/** sets the scalarpressuresummarycolor */
	void setScalarPressureSummaryColor(QColor&);
	/** gives back the scalarpressuresummarycolor */
	QColor& scalarPressureSummaryColor();
	
private:
	QColor cgrid, cpressure, cimpedance, cpressureS, cimpedanceS, cscalarpressureS;
	int m_Schall1,m_Schall2,m_Schall3;
	double Faktor;
	double Start;
	double Xvalue[150];
	
	int YScale (double, int type);  //type : pressure=0, impedanz=1
	void FilterView::initXvalue();
	int FilterView::XK(double x);
	void FilterView::paintEvent( QPaintEvent * );
	
};

#endif // FILTERVIEW_H
