/***************************************************************************
                          kbpickicondlg.cpp  -  description
                             -------------------
    begin                : Sat Jul 21 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbpickicondlg.h"

#include <qvbox.h>
#include <qdir.h>

#include <kiconview.h>
#include <klocale.h>
#include <kstddirs.h>
#include <kglobal.h>

KBPickIconDlg::KBPickIconDlg(QWidget *parent, const char *name )
  : KDialogBase(parent, name, true /*modal*/, i18n("Pick an icon") /*caption*/, Ok | Cancel) {
  QVBox *page = makeVBoxMainWidget();
  m_iconview = new KIconView(page);
  m_iconview->setAutoArrange(true);
  m_iconview->setItemsMovable(false);
  m_iconview->setResizeMode(QIconView::Adjust);
  QObject::connect(m_iconview, SIGNAL(doubleClicked(QIconViewItem *)),
    this, SLOT(slotOk()));
  QObject::connect(m_iconview, SIGNAL(returnPressed(QIconViewItem *)),
    this, SLOT(slotOk()));

  QPixmap pix;
  QDir dir;
  QStringList locales;
  QString path;
  QStringList dirs = KGlobal::dirs()->findDirs("locale", "l10n");
  for (QStringList::Iterator dirIter = dirs.begin(); dirIter != dirs.end(); dirIter++) {
    dir.setPath(*dirIter);
    locales = dir.entryList(QDir::Dirs, QDir::Name);
    for (QStringList::Iterator iter = locales.begin(); iter != locales.end(); iter++) {
      path = dir.path() + "/" + *iter + "/flag.png";
      if (*iter != "." && *iter != ".." && pix.load(path)) {
        (void) new QIconViewItem(m_iconview, *iter, pix);
        m_pathnames.append(path);
      }
    }
  }
}

KBPickIconDlg::~KBPickIconDlg(){
}

/** Get the path name of the selected icon. Returns empty string if no icon selected */
QString KBPickIconDlg::getIconPath(){
  if (m_iconview->currentItem()) {
    int index = m_iconview->currentItem()->index();
    if (index >= 0 && (unsigned int) index < m_pathnames.count())
      return m_pathnames[index];
  }
  return QString::null;
}

/** No descriptions */
QPixmap* KBPickIconDlg::getIcon(){
  if (m_iconview->currentItem())
    return m_iconview->currentItem()->pixmap();
  else return 0;
}
