/***************************************************************************
                          filegroupext.h  -  description
                             -------------------
    begin                : Thu Jan 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEGROUPEXT_H
#define FILEGROUPEXT_H

#include <filegroupbase.h>

#include "schedule.h"

/**
  *@author Arjan Buursink
  */
enum action {DELETE_BACKUP, DELETE, ARCHIVE, MOVE};

class FileGroupExt : public FileGroupBase  {
	Q_OBJECT
public:
	FileGroupExt();
	~FileGroupExt();
	ABProcess * move(QString = "");
	ABProcess * remove();
	ABProcess * archive(QString,QString, bool);
	QList<bool> * restoreMarkList;
	void empty();
	/**
	* Destination of move process
	*/
	QString destDir;
	int nextMarked(int);
	// used for moving files
	void init();
	/**
	 * Adds file to the group. No check is performed if file is already in the group!
	 */
//	void addFile(QString);
//	void removeFile(const unsigned int);
	virtual QString archiveRoot(){return QString("");};
	/**
	* Returns the base file name
	*/
	QString baseFileName();
	/**
	* Returns the archive file name given directory d and number n
	*/
	QString archiveFileName(QString, unsigned int);
	/**
	* Returns the number of the oldest archive in a directory
	*/
	unsigned int oldestArchive(QString);
	/**
	* Returns the absolute file path of the next to be made archive
	*/
	QString nextArchiveFileName(QString );
	/**
	* Returns the maximum number of possible archives and backups
	*/
	unsigned int maxArchives() {return maxarchs;};
	/**
	* Sets the maximum number of possible archives and backups
	*/
	void setMaxArchives(unsigned int i) {maxarchs = i;};
	/**
	* Object for scheduling events
	*/
	void setScheduleEnabled(bool b) { ensched = b; };
	Schedule * schedule() { return sched; };
	bool scheduleEnabled() { return ensched; };
	void setAction(action a) { act = a; };
	action getAction() { return act;};
	void setCommand(QString s){ cmd = s;};
	QString command(){ return cmd;};
	unsigned int lastEvent() {return lstevent;};
	void setLastEvent();
	void setLastEvent(unsigned int l) {lstevent = l;};
	bool missedScheduleEvent();
private:
	Schedule * sched;
	bool ensched;
	QString archroot;
	QString archdir;
	unsigned int maxarchs;
	action act;
	QString cmd;
	void execCommand();
	unsigned int lstevent;
protected:
	/**
	* The base file name. That's the file name without its extension (.config, .files)
	*/
	QString bfn;
private slots:
	void slotAction();
signals:
	void Action();
};

#endif
