/***************************************************************************
                          filelistview.cpp  -  description
                             -------------------
    begin                : Sat Aug 12 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <stdlib.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qiconset.h>
#include <kapp.h>
#include <kstddirs.h>
#include <kurlpixmapprovider.h>
#include "filelistview.h"

FileListView::FileListView(QWidget *parent=0, const char *name=0) : QListView(parent,name){
	KIconLoader l;
	QIconSet s(l.loadIcon("mime_empty", KIcon::Small));
	this -> addColumn(s,0);
	setColumnWidthMode(0,QListView::Maximum);
	this -> addColumn("Filename",125);
 	this -> addColumn("Folder",250);
 	this -> addColumn("Size",65);
	this -> addColumn("Last read",150);
	this -> setColumnAlignment(3,2);
	this -> setColumnAlignment(4,1);
	this -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	this -> setItemMargin(2);
	setAllColumnsShowFocus (true);
	init();
	fgroup = 0;
}

FileListView::~FileListView(){
}

void FileListView::init(){
	this -> clear();
	setColumnWidth(0,0);
}

void FileListView::setFileGroup(FileGroupBase * f){
	init();
	fgroup = f;
	emit fileSelectionChanged(f);
	QString s;
	for (unsigned int i = 0; i < fileGroup() -> numFiles() ; i++){
		QListViewItem * item = new QListViewItem(this);
		setupItem(item, i);
  }
}

void FileListView::setupItem(QListViewItem * i, unsigned int n){
	QString tmp(fileName(i));
	if (fileName(i).isEmpty()){
		QString s;
		QFileInfo fi(fileGroup() -> file(n));
		QDateTime dat(fi.lastRead());
		i -> setText(1,fi.fileName());
		i -> setText(2,fi.dirPath());
		i -> setText(3,s.setNum(fi.size()));
		i -> setText(4," " + dat.toString());
/*		KURLPixmapProvider p;
		i -> setPixmap(0,p.pixmapFor(fileName(i),KIcon::SizeSmall));*/
	}

	if (fileGroup() -> fileMark(n)){
		if (isSafe(fileName(i)))
			i -> setPixmap(1,QPixmap(getenv("KDEDIR") + QString("/") + KStandardDirs::kde_default("data")+"/kleandisk/pics/green_marked.xpm"));
		else
			i -> setPixmap(1,QPixmap(getenv("KDEDIR") + QString("/") + KStandardDirs::kde_default("data")+"/kleandisk/pics/red_marked.xpm"));
	}
	else{
		if (isSafe(fileName(i)))
			i -> setPixmap(1,QPixmap(getenv("KDEDIR") + QString("/") + KStandardDirs::kde_default("data")+"/kleandisk/pics/green.xpm"));
		else
			i -> setPixmap(1,QPixmap(getenv("KDEDIR") + QString("/") + KStandardDirs::kde_default("data")+"/kleandisk/pics/red.xpm"));
	}
}

void FileListView::viewportMousePressEvent(QMouseEvent *e){
	if (fileGroup()){
		QListViewItem * i = itemAt(e -> pos());
		int j = fileGroup() -> file(fileName(i));
		int x = columnWidth(0);
		if (e -> x() > x  && e -> x() <= x + 12){
			fileGroup() -> setFileMark(j,!fileGroup() -> fileMark(j));
			setupItem(i,j);
		}
		else{
			if (e -> button() == LeftButton)
				setSelected(i,true);
		}
		emit fileSelectionChanged(fileGroup());
	}
}

void FileListView::markAll(){
	if (fileGroup()){
		QListViewItem * item = firstChild();
		while (item != 0L){
			QString s(fileName(item));
			unsigned int i = fileGroup() -> file(s);
			if (isSafe(s)){
				fileGroup() -> setFileMark(i, true);
				setupItem(item,i);
			}
			else{
				fileGroup() -> setFileMark(i, false);
				setupItem(item,i);
			}
			item = item -> itemBelow();
		}
	}
	emit fileSelectionChanged(fileGroup());
}

void FileListView::deMarkAll(){
	if (fileGroup()){
		QListViewItem * item = firstChild();
		while (item != 0L){
			unsigned int i = fileGroup() -> file(fileName(item));
			fileGroup() -> setFileMark(i, false);
			setupItem(item,i);
			item = item -> itemBelow();
		}
	}
	emit fileSelectionChanged(fileGroup());
}

bool FileListView::isSafe(QString s){
	bool b;
	QDateTime current_date_time = QDateTime::currentDateTime();
	QFileInfo fi(s);
	QDateTime dat(fi.lastRead());
	unsigned int t = dat.secsTo(current_date_time)/(86400);
	if (t < fileGroup() -> safetyLevel())
		b = false;
	else
		b = true;
	return b;
}

QString FileListView::fileName(QListViewItem * i){
	QString s = i -> text(2);
	s = s + "/" + i -> text(1);
	if (s == QString("/"))
		s = "";
	return s;
}

