/***************************************************************************
                          groupmanager.h  -  description
                             -------------------
    begin                : Wed Nov 8 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUPMANAGER_H
#define GROUPMANAGER_H


/**
  *@author Arjan Buursink
  */

#include <qtimer.h>

#include "udg.h"
#include "rpm.h"
#include "ins.h"

#include "searchprogress.h"
#include "queryprogress_2.h"

/**
  *@author Arjan Buursink
  */

class GroupManager : public QObject  {
	Q_OBJECT
public:
	GroupManager();
	~GroupManager();
	unsigned int count(grouptype);
	UDG * udg(unsigned int i) { return udgList -> at(i);};
	RPM * rpm(unsigned int i) { return rpmList -> at(i);};
	INS * ins(unsigned int i) { return insList -> at(i);};

	UDG * udg(QString);
	RPM * rpm(QString);
	INS * ins(QString);

	void add(UDG* g) { udgList -> append(g); };
	void add(RPM* g) { rpmList -> append(g); };
	void add(INS* g) { insList -> append(g); };
	/**
	* Saves all filegroups to disk
	*/
	void save();
	/**
	* Uninstalls the udg. The corresponding files are also uninstalled.
	*/
	void remove(grouptype,unsigned int);
	void remove(grouptype,QString);
	void startScheduling();
	void stopScheduling();

	ABProcess * updateProcess;
	Schedule * schedule;
	void update(grouptype,QString dir="");
	/**
	* Shows/Hides the search progress
	*/
	void showUpdateProgress(grouptype, bool);
	unsigned int rpmSafetyLevel() { return rpmslvl;};
	void setRPMSafetyLevel(unsigned int );	
	void clear(grouptype);
	void init(grouptype);
	bool isInit(grouptype);
public slots:
	void slotUpdateUDG(KProcess *, char * , int );
	void slotUpdateReady();
//	void slotRPMReady();
	void slotRPMQueryEnded();
	void slotCancel();
private slots:
	void slotRPM();
private:
	bool initUDG, initRPM, initINS;
	SearchProgress * updateUDGProgress;
	QueryProgress_2 * updateRPMProgress;
	QList<UDG> * udgList;
	QList<RPM> * rpmList;
	QList<INS> * insList;
	/**
	* Checks for UDG config files an adds them to the UDG List
*/
	void setupDefaultUDG();
	QString std;
	void slotUpdateUDG();
	void slotSearchReady();
	unsigned int counter;
	RPM * _rpm;
	grouptype updateType;
	unsigned int rpmslvl;
	QTimer * timer;
signals:
	void updateReady();
};

#endif