/***************************************************************************
                          restorewizard_2.cpp  -  description
                             -------------------
    begin                : Mon Jan 17 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "restorewizard_2.h"
#include <stdlib.h>
#include <qfileinfo.h>
#include <kapp.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include "info.h"

RestoreWizard_2::RestoreWizard_2(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	QListView_1 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	QListView_1 -> addColumn("File",175);
	QListView_1 -> addColumn("Folder",250);
	QListView_1 -> setMultiSelection(true);
	QRadioButton_1 -> setChecked(true);
	tar = new ABProcess("tar");
	tarExited = true;
	connect(tar,SIGNAL(processExited(KProcess *)),SLOT(slotTarExited()));
	connect(QRadioButton_1,SIGNAL(clicked()),SLOT(slotYesClicked()));
	connect(QRadioButton_2,SIGNAL(clicked()),SLOT(slotNoClicked()));
	connect(QPushButton_1, SIGNAL(clicked()), SLOT(slotBrowse()));
	connect(QPushButton_2, SIGNAL(clicked()), SLOT(slotDeSelectAll()));
	connect(QPushButton_3, SIGNAL(clicked()), SLOT(slotSelectAll()));
}

RestoreWizard_2::~RestoreWizard_2(){
}

void RestoreWizard_2::setArchive(QListViewItem *i){
	tarExited = false;
	QLineEdit_1 -> setText(i -> text(5));
	QListView_1 -> clear();
	arch = i -> text(4);
	tar -> clearArguments();
	*tar << "tar";
	*tar << "ztf";
	*tar << arch;
	tar -> init();
	tar -> start(KProcess::NotifyOnExit, KProcess::AllOutput);

}

void RestoreWizard_2::slotYesClicked(){
	QPushButton_2 -> setEnabled(false);
	QPushButton_3 -> setEnabled(false);
	slotDeSelectAll();
	enableItems(false);
}

void RestoreWizard_2::slotNoClicked(){
	QPushButton_2 -> setEnabled(true);
	QPushButton_3 -> setEnabled(true);
	slotDeSelectAll();
	enableItems(true);
}

void RestoreWizard_2::slotSelectAll(){
	QListViewItem *i = QListView_1 -> firstChild();
	while (i != 0L){
		if (fileExists(i))
			QListView_1 -> setSelected(i,false);
		else
			QListView_1 -> setSelected(i,true);
		i = i -> itemBelow();
	}
}

void RestoreWizard_2::slotDeSelectAll(){
	QListViewItem *i = QListView_1 -> firstChild();
	while (i != 0L){
		QListView_1 -> setSelected(i,false);
		i = i -> itemBelow();
	}
}

void RestoreWizard_2::slotTarExited(){
	QFileInfo fi;
  KIconLoader icnl;
	for (uint i = 0; i < tar -> output -> count(); i++){
		fi = QFileInfo(tar -> output -> at(i));
		QListViewItem * item = new QListViewItem(QListView_1, fi.fileName(),fi.dirPath());
		if (fileExists(item))
			item -> setPixmap(0,QPixmap(icnl.loadIcon("remove",KIcon::Small)));
		else
			item -> setPixmap(0,QPixmap(icnl.loadIcon("ok",KIcon::Small)));
	}
	tarExited = true;
	QRadioButton_1 -> setChecked(true);
	slotYesClicked();
}

void RestoreWizard_2::slotBrowse(){
	QLineEdit_1 -> setText(KFileDialog::getExistingDirectory());
	QListViewItem * item = QListView_1 -> firstChild();
  KIconLoader icnl;
	while (item != 0 ){
		if (fileExists(item))
			item -> setPixmap(0,QPixmap(icnl.loadIcon("kit_warning",KIcon::Small)));
		else
			item -> setPixmap(0,QPixmap(icnl.loadIcon("mime_empty",KIcon::Small)));
		item = item -> itemBelow();
	}
}

int RestoreWizard_2::overWrite(){
	int i = 0;
	QListViewItem * item = QListView_1 -> firstChild();
	while (item != 0 ){
		if (fileExists(item) & (item -> isSelected()| QRadioButton_1 -> isChecked()) )
			i++;
		item = item -> itemBelow();
	}
	return i;
}

bool RestoreWizard_2::fileExists(QListViewItem * item){
	QFileInfo fi(QString(QLineEdit_1 -> text()) + item -> text(1) + "/" + item -> text(0));
	bool b = fi.exists();
	return b;
}

void RestoreWizard_2::enableItems(bool b){
	QListView_1 -> setEnabled(b);
	QListViewItem *item = QListView_1 -> firstChild();
	while (item != 0L){
		item -> setSelectable(b);
		item = item -> nextSibling();
	}
}

unsigned int RestoreWizard_2::numSelected(){
	unsigned int s = 0;
	if (QRadioButton_1 -> isChecked())
		s = QListView_1 -> childCount();
	else{
		QListViewItem * i = QListView_1 -> firstChild();
		while (i != NULL){
			if (i -> isSelected())
				s++;
			i = i -> itemBelow();
		}
	}
	return s;
}
