/***************************************************************************
                          udgeditgeneral.cpp  -  description
                             -------------------
    begin                : Fri Mar 24 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "udgeditgeneral.h"
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kstddirs.h>
#include "abicondialog.h"
#include "info.h"

UDGEditGeneral::UDGEditGeneral(UDG * g, QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	groupToEditor(g);
	connect(QPushButton_1, SIGNAL(clicked()),SLOT(slotBrowsePixmap()));
}

UDGEditGeneral::~UDGEditGeneral(){
}

void UDGEditGeneral::groupToEditor(UDG * g){
	QLineEdit_1 -> setText(g -> name());
  QMultiLineEdit_1 -> setWordWrap(QMultiLineEdit::WidgetWidth);
	QMultiLineEdit_1 -> setText(g -> description());
	KIconLoader l;
	QPushButton_1 -> setPixmap(l.loadIcon(g -> icon(), KIcon::Small));
	icon = g -> icon();
	u = g;
}

void UDGEditGeneral::slotBrowsePixmap(){
	ABIconDialog d;
	d.exec();
	KIconLoader l;
	if (d.icon()){
		QPushButton_1 -> setPixmap(l.loadIcon(d.icon(), KIcon::Small));
		icon = d.icon();
	}
}

void UDGEditGeneral::editorToGroup(){
	u -> setName(QLineEdit_1 -> text());
	u -> setDescription(QMultiLineEdit_1 -> text());
	u -> setIcon(icon);
}

QString UDGEditGeneral::error(){
	QString e;
	e = QString::null;
	if (QLineEdit_1 -> text() == QString(""))
		e = i18n("The group must have a name");
	return e;
}
