/***************************************************************************
                          udgeditsettings.cpp  -  description
                             -------------------
    begin                : Fri Mar 24 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "udgeditsettings.h"

UDGEditSettings::UDGEditSettings(UDG * g, QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	groupToEditor(g);
}

UDGEditSettings::~UDGEditSettings(){
}

void UDGEditSettings::groupToEditor(UDG * g){
	QSpinBox_1 -> setValue(g -> safetyLevel());
	QSpinBox_2 -> setValue(g -> maxArchives());
	QLineEdit_1 -> setText(g -> command());
	u = g;
}

void UDGEditSettings::editorToGroup(){
	u -> setSafetyLevel(this -> safetyLevel());
	u -> setMaxArchives(this -> maxArchives());
	u -> setCommand(this -> QLineEdit_1 -> text());
}

unsigned int UDGEditSettings::safetyLevel(){
	QString s(QSpinBox_1 -> text());
	return s.toInt();

}

unsigned int UDGEditSettings::maxArchives(){
	QString s(QSpinBox_2 -> text());
	return s.toInt();
}