/***************************************************************************
                          cleanupwizard.h  -  description
                             -------------------
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CLEANUPWIZARD_H
#define CLEANUPWIZARD_H

#include <cleanupbase.h>
#include "filegroupext.h"
#include "buttonlabelwidget3.h"
#include "batch.h"
#include "logviewwidget.h"

/**
  *@author Arjan Buursink
  */

class CleanupWizard : public CleanupBase  {
	Q_OBJECT
public:
	CleanupWizard(FileGroupExt *);
	~CleanupWizard();
private:
	QString t,t_2,t_3,t_4,t_5, t_6;
	FileGroupExt * fileGroup;
	ButtonLabelWidget3 * progress;
	ABProcess * proc;
	Batch * batch;
	LogViewWidget * logView;
	void accept();
	void reject(){emit ready(); delete this;};
	void slotDelete();
	void slotArchive();
	void slotMove();
	void slotBrowseBackup();
	void slotBrowseArchive();
	void slotBrowseMove();
	void slotLog(){logView -> show();};
	void initPages();
	void setInfo(QString);
private slots:
	void slotCleanUpCompleted();
signals:
	void ready();
};
#endif
