/***************************************************************************
                          filegroupext.cpp  -  description
                             -------------------
    begin                : Thu Jan 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filegroupext.h"
#include <stdlib.h>
#include <qtextstream.h>
#include <ksimpleconfig.h>
#include <klocale.h>
#include "info.h"
#include "helperfunctions.h"

FileGroupExt::FileGroupExt() : btch(true){
	connect(&btch,SIGNAL(batchExited()), SLOT(slotBatchExited()));
	sched = new Schedule();
	sched -> start();
	connect (schedule(), SIGNAL(action()), SLOT(slotAction()));
	init();
}

FileGroupExt::~FileGroupExt(){
	delete sched;
}

void FileGroupExt::init(){
	setName("");
	bfn = "";
	setSafetyLevel(0);
	setMaxArchives(0);
	setLastEvent(0);
	setCommand("");
	unloadFiles();
	setScheduleEnabled(false);
	setAction(DELETE_BACKUP);
}

void FileGroupExt::empty(){
	unloadFiles();
}


ABProcess * FileGroupExt::move(const QString d){
	ABProcess * p = new ABProcess("mv");	
	p -> clearArguments();
	*p << "mv";
	*p << "-v";
	int i = nextMarked(-1);
	while (i != -1){
		*p << file(i);
		i = nextMarked(i);
	}
	*p << d;
	return p;
}

ABProcess * FileGroupExt::remove(){
	ABProcess * p = new ABProcess("rm");	
	p -> clearArguments();
	*p << "rm";
	*p << "-vf";
	int i = nextMarked(-1);
	while (i != -1){
		*p << file(i);
		i = nextMarked(i);
	}
	return p;
}

ABProcess * FileGroupExt::archive(const QString n, QString d, const bool a){
	if (numFiles()){
		// write backup info to file with extension info
		KSimpleConfig cfg(n + ".info");
		cfg.writeEntry("Archive",a);
//		cfg.writeEntry("Group Type",type);
		cfg.writeEntry("Icon",icon());
		cfg.writeEntry("Name",name());
		cfg.writeEntry("Number of Files",numMarked());
		while (d.right(1) == "/")// remove /'s from the end
			d.remove(d.length() - 1,1);
		d = d	+ "/"; // and add one slash again. Now we are sure the dir d ends on one slash.	
		cfg.writeEntry("Archive Root",d);
		QStrList sl;
		ABProcess * p = new ABProcess("tar");
		p -> clearArguments();
		*p << "tar";	
		*p << "czvf";
		*p << n;
		*p << "-C";
		*p << d;
		int cntr = 0;
		int i = nextMarked(-1);
		while (i != -1){
			cntr++;
			QString f(file(i));
			QFileInfo fi(f);
			if (cntr <= 10)
				sl.append(fi.fileName());
			f = f.right(f.length()- d.length()); // strip directory d from file
			*p << f;
			i = nextMarked(i);
		}
		cfg.writeEntry("Files",sl);
	return p;
	}
	else return NULL;
}

int FileGroupExt::nextMarked(int i){
	i++;
	if ((unsigned int)i >= numFiles() | i < 0)
		i = -1;
	else{
		while (!fileMark(i)){
			i++;
			if (i == (int)numFiles()){
				i = -1;
				break;
			}
		}
	}
	return i;
}

QString FileGroupExt::archiveFileName(const QString d, const unsigned int n){
	QString num;
	return d + baseFileName() + QString("_") + num.setNum(n) + ".tgz";
}

QString FileGroupExt::nextArchiveFileName(const QString d){
	unsigned int n = 1;
	QFileInfo fi(archiveFileName(d,n));
	while (fi.exists()){
		n++;
		if (maxArchives() > 0 && n > maxArchives()){
			fi = QFileInfo(archiveFileName(d,oldestArchive(d)));
			return fi.absFilePath();
		}
		fi = QFileInfo(archiveFileName(d,n));
	}
	return fi.absFilePath();
}

unsigned int FileGroupExt::oldestArchive(const QString d){
	int n = 1;
	int i = 1;
	QFileInfo fi(archiveFileName(d,n));
	QDateTime dt = fi.lastModified();
	QDateTime min_dt;
	min_dt = min_dt.currentDateTime();
	while (fi.exists()){
		if (dt < min_dt){
			min_dt = dt;
			i = n;
		}
		n++;
		fi = QFileInfo(archiveFileName(d,n));
		dt = fi.lastModified();
	}		
	return i;
}

QString FileGroupExt::baseFileName(){
	if (bfn == QString("")){
		QString n(name());
		for (uint i = 0; i < n.length(); i++){
			if (n.mid(i,1) == QString("/"))
				n.replace(i,1,"|");
			if (n.mid(i,1) == QString(" "))
				n.replace(i,1,"_");
			if (n.mid(i,1) == QString("."))
				n.replace(i,1,"_");
		}
		bfn = n;
	}
	return bfn;
}

void FileGroupExt::slotAction(){
	printf("action\n");
	setLastEvent();
	sync();
	markGreen();
	QString st;
	if (scheduleEnabled() & numMarked() > 0){
		if (act == DELETE_BACKUP){
			emit status(name() + ":\n" + i18n("Backing up and deleting..."));
			btch.append(archive(nextArchiveFileName(defaultArchiveDir()), archiveRoot(),true), this);
			btch.append(remove(), this);
			btch.start();
		}
		if (act == DELETE){
			emit status(name() + ":\n" + i18n("Deleting..."));
			btch.append(remove(), this);
			btch.start();
		}
		if (act == ARCHIVE){
			emit status(name() + ":\n" + i18n("Archiving..."));
			btch.append(archive(nextArchiveFileName(defaultArchiveDir()), archiveRoot(),true), this);
			btch.start();
		}
	}
	sync();
}

void FileGroupExt::slotBatchExited(){
	btch.clear();
	emit status(i18n("Ready.\n"));
	if (command() != QString(""))
		system(command());
}

void FileGroupExt::setLastEvent(){
	QDateTime dt1970;
	QDateTime dtNow;
	dt1970.setTime_t(0);
	dtNow = dtNow.currentDateTime();
	setLastEvent(dt1970.secsTo(dtNow));
}	

bool FileGroupExt::missedScheduleEvent(){
	bool b = false;
	QDateTime dt1970;
	dt1970.setTime_t(0);

	QDateTime dtLastSchedEvent;
	dtLastSchedEvent = schedule() -> lastEvent();

	QDateTime dtLastEvent;
	dtLastEvent.setTime_t( lastEvent());

	int sec1 = dt1970.secsTo(dtLastSchedEvent);
	int sec2 = lastEvent();
	int diff = sec1 - sec2;

	
	if (diff >= 60)
		b = true;
	return b;
}
