/***************************************************************************
                          udgtree.cpp  -  description
                             -------------------
    begin                : Wed Dec 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "udgtree.h"
#include "udg.h"
#include <stdlib.h>
#include <qdir.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <kmessagebox.h>
#include <udgeditordialog.h>
#include "groupviewwidget.h"
#include "info.h"
#include <iostream.h>

UDGTree::UDGTree(GroupViewWidget * gv) : GroupTree(gv){
  setType(TYPE_UDG);
	KIconLoader l;
	topItem() -> setText(0,"UDG");
	topItem() -> setPixmap(0,l.loadIcon("mime_empty", KIcon::Small));	
}

UDGTree::~UDGTree(){
}

void UDGTree::itemClicked(QListViewItem * i, const QPoint &p, int c){
	if (c == 0)
		setup();
	if (i != 0){
		if (i == topItem())
	    i -> setOpen(!i -> isOpen());
		if (i -> parent() == topItem()){
			switch (c){
				case 0:
					emit setupFileList(group(name(i)));
					emit setProperties(group(name(i)));
					break;
				case 7:
					if (  !( (UDG*)group(name(i)) ) -> schedule() -> isIllegalSchedule() ) {
						( (UDG*) group(name(i)) ) -> setScheduleEnabled(!( (UDG*) group(name(i)) ) -> scheduleEnabled());
						( (UDG*) group(name(i)) ) -> save();
					}
					break;
			}
			setupItem(((UDG*)group(name(i))), i);
		}
	}
	setupReady();
}

void UDGTree::groupToItem(FileGroupBase * g, QListViewItem * i){
	UDG * u = (UDG*)g;
	KIconLoader l;
	i -> setPixmap(0,l.loadIcon(u -> icon(), KIcon::Small));
	if (u -> scheduleEnabled()){
		if (u -> getAction() == DELETE_BACKUP){
			if (u -> missedScheduleEvent())
				i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_yellow_broken.xpm")));
    	else
				i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_yellow.xpm")));
		}
		if (u -> getAction() == DELETE){
			if (u -> missedScheduleEvent())
				i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_red_broken.xpm")));
			else	
				i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_red.xpm")));
		}
		if (u -> getAction() == ARCHIVE){
			if (u -> missedScheduleEvent())
				i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_green_broken.xpm")));
			else	
				i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_green.xpm")));
		}
	}
	else{
		if (u -> schedule() -> dayList().count()>0 || u -> schedule() -> dayCycle()>0)
			i -> setPixmap(7,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/schedule_gray.xpm")));
		else
		i -> setPixmap(7,QPixmap());
 	}
}

void UDGTree::slotPopup(QListViewItem * i, const QPoint & p, int c){
	popup = new QPopupMenu();
	if (i == topItem()){
		popup -> insertItem(i18n("New UDG"),this,SLOT(slotNewUDG()));
	}
	if (i -> parent() == topItem()){
		listView() -> setSelected(i,true);
		popup -> insertItem(i18n("New UDG"),this,SLOT(slotNewUDG()));
		popup -> insertItem(i18n("Edit"),this,SLOT(slotEditUDG()));
		popup -> insertItem(i18n("Delete"),this,SLOT(slotDeleteUDG()));
		UDG * g = (UDG*)group(name(selectedItem()));
		if (g -> dir().left(1) == "/")
			popup -> insertItem(i18n("Update"),this,SLOT(slotUpdateGroup()));
		popup -> insertItem(i18n("Quick Archive"),this,SLOT(slotQuickArchive()));
		if (g -> scheduleEnabled())
			popup -> insertItem(i18n("Execute next scheduled action"),g,SLOT(slotAction()));
	}
	popup -> popup(p);
}

void UDGTree::slotNewUDG(){
	UDG * g = new UDG("");
	g -> setName(i18n("New Group"));
	UDGEditorDialog d(g);
	d.exec();
	if (d.result() == 0){
		setup();
		addGroup(g);
		saveGroups();
	}
	if (d.result() == 1)
		delete g;
}

void UDGTree::slotEditUDG(){
	QListViewItem * i = selectedItem();
	UDG * g = (UDG*)group(name(selectedItem()));
	UDGEditorDialog d(g);
	d.exec();
	setupItem(g,i);
	if (d.result() == 0)
		saveGroups();
	emit setupFileList(g);
}

void UDGTree::slotDeleteUDG(){
	if (KMessageBox::questionYesNo(0,i18n("Are you shure you want to delete this group?\n The files will remain on disk"),i18n("Delete Group")) == KMessageBox::Yes){
		QListViewItem * i = selectedItem();
		group(name(i)) -> unInstall() -> start();
		removeGroup(name(i));
		delete i;
	}
}

void UDGTree::slotQuickArchive(){
	UDG * u = (UDG*)group(name(selectedItem()));
	u -> markAll();
	proc = u -> archive(u -> nextArchiveFileName(defaultArchiveDir()),u -> archiveRoot(), true);
	if (proc){
		progress = new ButtonLabelWidget3();
		progress -> show();
		progress -> TextLabel1 -> setText(i18n("Archive"));
		progress -> ProgressBar1 -> setTotalSteps(u -> numMarked());
		connect(progress -> PushButton1, SIGNAL(clicked()),SLOT(slotQuickArchiveCancelClicked()));
		connect(proc, SIGNAL(processExited(KProcess*)), SLOT(slotQuickArchiveCompleted()));
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		proc -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
	}
}

void UDGTree::slotQuickArchiveCompleted(){
	delete progress;
	delete proc;
}

void UDGTree::slotCleanupEnded(){
	UDG * g;
		g = (UDG*)group(name(selectedItem()));
	g -> sync();
	setupItem(g,selectedItem());
	groupViewWidget() -> FileListView1 -> setFileGroup(g);
}

void UDGTree::setup(){
	if (topItem() -> childCount() == 0){
		bool b = false;
		QDir d(udgDir());
		QStringList * l = new QStringList(d.entryList());
		for (unsigned int i = 0; i < l -> count(); i++){
			QFileInfo f(udgDir() + QString(*l -> at(i)));
			QString s(f.fileName());
			if (s.right(7) == ".config"){
				b = true;
				UDG * u = new UDG(f.baseName());
				u -> load();
				addGroup(u);
			}
		}
		delete l;
		if (!b){
			if (KMessageBox::questionYesNo(0
			,i18n("No file groups have been found.\nShould I install the default groups?")
			,i18n("Install Default Groups")) == KMessageBox::Yes)
				setupDefaultGroups();
		}
	}
}

void UDGTree::saveGroups(){
	for (unsigned int i = 0; i < groupCount(); i++)
		((UDG*)group(i)) -> save();
}

void UDGTree::update(QString dir){
	updateProcess = new ABProcess("find");
	updateProgress = new ButtonLabelWidget();
	if (dir != QString("")){
		connect(updateProcess, SIGNAL(receivedStdout(KProcess *,char *, int))
			,SLOT(slotUpdateGroups(KProcess *,char *,int )));
			connect(updateProcess, SIGNAL(processExited(KProcess *)),SLOT(slotUpdateReady()));
		updateProcess -> clearArguments();
		*updateProcess << "find";
		*updateProcess << dir;
		updateProcess -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
	}
}

void UDGTree::slotUpdateGroups(){
	setup();
	listView() -> setSelected(topItem(), true);
	for (unsigned int i = 0; i < groupCount(); i++)
		group(i) -> unloadFiles();
	update(getenv("HOME"));
	updateProgress -> setCaption(i18n("Analyzing files..."));
	updateProgress -> setFocus();
	updateProgress -> show();
}

void UDGTree::slotUpdateGroup(){
	UDG * g = (UDG*)group(name(selectedItem()));
	update(g -> dir());
}

void UDGTree::slotUpdateGroups(KProcess *, char * b, int l){
	QString f;
	QFileInfo fi;
  char * nb = new char[l+1];
  for (int i = 0; i <= l - 1; i++)
		nb[i] = b[i];
	nb[l] = '\0';
	std.append(nb);
	delete nb;
	uint i = 1;
	QString txt = "";
  while (i <= std.length()){
		if (std.mid(i,1) == "\n"){
	 		f = std.left(i);
	 		fi.setFile(f);
			if (fi.isFile() & (fi.ownerId()==getuid() | getuid() == 0)){
				txt = fi.dirPath();
				if (txt != updateProgress -> TextLabel1 -> text())
					updateProgress -> TextLabel1 -> setText(txt);
				for (uint j = 0; j < groupCount(); j++)
					((UDG*)group(j)) -> tryFile(f);
			}
			std = std.right( std.length() - i - 1);
			i = 0;
		}
		i++;
  }
}

void UDGTree::updateReady(){
	for (unsigned int i = 0; i < groupCount(); i++){
		group(i) -> sync();
		((UDG*)group(i)) -> save();
		setupItem(group(i), item(topItem(), group(i) -> name()) );
	}
	topItem() -> setOpen(true);
	updateProgress -> hide();
}

void UDGTree::setupDefaultGroups(){
		UDG * u = new UDG("");
		u -> setName(i18n("Trash Files"));
		u -> setDescription(i18n("These files have been put in the trash by the user."));
		u -> setDir("~/Desktop/Trash");
		u -> addPattern("*");
		u -> setIcon("trash.png");
		u -> setSafetyLevel(7);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Backup Files"));
		u -> setDescription(i18n("The files in this group are usually left by text editors after saving an already existing file."));
		u -> addPattern("*~");
		u -> setIcon("recycled.png");
		u -> setSafetyLevel(7);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Object Files"));
		u -> setDescription(i18n("Object files are created during compile time of a program. After linking these files into an executable they are not needed anymore unless you are a developer."));
		u -> addPattern("*.o");
		u -> setIcon("source_o.png");
		u -> setSafetyLevel(2);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Core Files"));
		u -> setDescription(i18n("Core files may appear when a program has crashed.It contains debugging information. When you are not a developer you don't need these files."));
		u -> addPattern("core");
		u -> setIcon("core.png");
		u -> setSafetyLevel(0);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Hidden Files"));
		u -> setDescription(i18n("Hidden files are usually left by programs to store configuration information. When a hidden file hasn't been accessed for a long time it probably means the corresponding program doesn't exist any more."));
		u -> addPattern(".*");
		u -> setIcon("mime_empty.png");
		u -> setSafetyLevel(28);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Temporary Files"));
		u -> setDescription(i18n("These files are mostly created by programs to store information."));
		u -> setDir("/tmp");
		u -> addPattern("*");
		u -> setIcon("mime_empty.png");
		u -> setSafetyLevel(2);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Messages log file"));
		u -> setDescription(i18n("You need root acces to empty this file"));
		u -> permanent -> append("/var/log/messages");
		u -> addPermanentFiles();
		u -> setCommand("killall -HUP syslogd");
		u -> setIcon("mime_empty.png");
		u -> setSafetyLevel(0);
		u -> schedule() -> setDayCycle(7);
		u -> schedule() -> addHour(20);
		u -> schedule() -> addMinute(0);
		u -> setAction(DELETE_BACKUP);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Netscape Cache"));
		u -> setDescription(i18n("Cache files created by Netscape"));
		u -> setIcon("netscape.png");
		u -> setDir("~/.netscape");
		u -> addPattern("cache*");
		u -> setSafetyLevel(7);
		u -> save();
		addGroup(u);

		u = new UDG("");
		u -> setName(i18n("Netscape Mail Trash"));
		u -> setDescription(i18n(""));
		u -> setIcon("netscape.png");
		u -> permanent -> append("~/nsmail/Trash");
		u -> addPermanentFiles();
		u -> setSafetyLevel(0);
		u -> save();
		addGroup(u);
}
