/***************************************************************************
                          filegroupext.cpp  -  description
                             -------------------
    begin                : Thu Jan 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filegroupext.h"
#include <stdlib.h>
#include <iostream.h>
#include <qtextstream.h>
#include <ksimpleconfig.h>
#include <klocale.h>
#include "info.h"
#include "helperfunctions.h"

FileGroupExt::FileGroupExt(){
	btch = new Batch();
	connect(batch(),SIGNAL(exit()), SLOT(slotBatchExited()));
	sched = new Schedule();
	sched -> start();
	connect (schedule(), SIGNAL(action()), SLOT(slotAction()));
	init();
}

FileGroupExt::~FileGroupExt(){
	delete sched;
	delete btch;
}

void FileGroupExt::init(){
	setName("");
	bfn = "";
	setSafetyLevel(0);
	setMaxArchives(0);
	setLastEvent(0);
	setCommand("");
	unloadFiles();
	setScheduleEnabled(false);
	setAction(DELETE_BACKUP);
}

void FileGroupExt::empty(){
	unloadFiles();
}


ABProcess * FileGroupExt::move(const QString d){
	QString filename(newFileName("/tmp/markedfiles"));
	setupMarkedFiles(filename);
	ABProcess * p = new ABProcess();	
	p -> clearArguments();
	*p << "cat";
	*p << filename;
	*p << "|";
	*p << "xargs";
	*p << "mv";
	*p << "-v";
	*p << "--target-directory";
	*p << QString("'") + d + "'";
	return p;
}

ABProcess * FileGroupExt::remove(){
	QString filename(newFileName("/tmp/markedfiles"));
	setupMarkedFiles(filename);
	ABProcess * p = new ABProcess();	
	p -> clearArguments();
	*p << "cat";
	*p << filename;
	*p << "|";
	*p << "xargs";
	*p << "rm";
	*p << "-vf";
	return p;
}

ABProcess * FileGroupExt::archive(const QString n, QString d, const bool a){
	if (numFiles()){
		// write backup info to file with extension info
		KSimpleConfig cfg(n + ".info");
		cfg.writeEntry("Archive",a);
		cfg.writeEntry("Icon",icon());
		cfg.writeEntry("Name",name());
		cfg.writeEntry("Number of Files",numMarked());
		while (d.right(1) == "/")// remove /'s from the end
			d.remove(d.length() - 1,1);
		d = d	+ "/"; // and add one slash again. Now we are sure the dir d ends on one slash.	
		cfg.writeEntry("Archive Root",d);

		QStrList sl;
		unsigned int cntr = 0;
		int i = nextMarked(-1);
			while (i != -1){
				cntr++;
				QString f(file(i));
				QFileInfo fi(f);
				if (cntr <= 10)
					sl.append(fi.fileName());
				i = nextMarked(i);
			}
		cfg.writeEntry("Files",sl);
		QString filename(newFileName("/tmp/markedfiles"));
		setupMarkedFiles(filename,d);
		ABProcess * p = new ABProcess();
		p -> clearArguments();
		*p << "cat";
		*p << filename;
		*p << "|";
		*p << "xargs";
		*p << "tar";
		*p << "czvf";
		*p << QString("'") + n + "'";
		*p << "-C";
		*p << QString ("'") + d + "'";
		return p;
	}
	else return NULL;
}

int FileGroupExt::nextMarked(int i){
	i++;
	if ((unsigned int)i >= numFiles())
		i = -1;
	else{
		while (!fileMark(i)){
			i++;
			if (i == (int)numFiles()){
				i = -1;
				break;
			}
		}
	}
	return i;
}

QString FileGroupExt::archiveFileName(const QString d, const unsigned int n){
	QString num;
	return d + baseFileName() + QString("_") + num.setNum(n) + ".tgz";
}

QString FileGroupExt::nextArchiveFileName(const QString d){
	unsigned int n = 1;
	QFileInfo fi(archiveFileName(d,n));
	while (fi.exists()){
		n++;
		if (maxArchives() > 0 && n > maxArchives()){
			fi = QFileInfo(archiveFileName(d,oldestArchive(d)));
			return fi.absFilePath();
		}
		fi = QFileInfo(archiveFileName(d,n));
	}
	return fi.absFilePath();
}

unsigned int FileGroupExt::oldestArchive(const QString d){
	int n = 1;
	int i = 1;
	QFileInfo fi(archiveFileName(d,n));
	QDateTime dt = fi.lastModified();
	QDateTime min_dt;
	min_dt = min_dt.currentDateTime();
	while (fi.exists()){
		if (dt < min_dt){
			min_dt = dt;
			i = n;
		}
		n++;
		fi = QFileInfo(archiveFileName(d,n));
		dt = fi.lastModified();
	}		
	return i;
}

QString FileGroupExt::baseFileName(){
	if (bfn == QString("")){
		QString n(name());
		n.replace(QRegExp("/"),"_");
		n.replace(QRegExp("'"),"_");
		n.replace(QRegExp("|"),"_");
		n.replace(QRegExp(" "),"_");
		n.replace(QRegExp("\\."),"_");
		n.replace(QRegExp("("),"_");
		n.replace(QRegExp(")"),"_");
		n.replace(QRegExp("\\$"),"_");
		bfn = n;
	}
	return bfn;
}

void FileGroupExt::setupMarkedFiles(QString filename, QString stripdir){
	QFile mf(filename);
	if (mf.open(IO_WriteOnly)){
		QTextStream t(&mf);
		int i = nextMarked(-1);
		while (i != -1){
			QString f(file(i));
			if (stripdir != NULL)
				f = f.right(f.length()- stripdir.length()); // strip directory d from file
			t << "\"" << f << "\"" << "\n";
			i = nextMarked(i);
		}
	}
	mf.close();
}

void FileGroupExt::slotAction(){
	batch() -> clear();
	setLastEvent();
	sync();
	markGreen();
	QString st;
	if (scheduleEnabled() & numMarked() > 0){
		if (act == DELETE_BACKUP){
			emit status(name() + ":\n" + i18n("Backing up and deleting..."));
			batch() -> append(archive(nextArchiveFileName(archiveDir()), archiveRoot(),true));
			batch() -> append(remove());
			batch() -> start();
		}
		if (act == DELETE){
			emit status(name() + ":\n" + i18n("Deleting..."));
			batch() -> append(remove());
			batch() -> start();
		}
		if (act == ARCHIVE){
			emit status(name() + ":\n" + i18n("Archiving..."));
			batch() -> append(archive(nextArchiveFileName(archiveDir()), archiveRoot(),true));
			batch() -> start();
		}
	}
	else
		batchExited(this);
}

void FileGroupExt::slotBatchExited(){
	batch() -> clear();
	emit status(i18n("Ready.\n"));
	if (command() != QString(""))
		system(command());
	sync();
	emit batchExited(this);
}

void FileGroupExt::setLastEvent(){
	QDateTime dt1970;
	QDateTime dtNow;
	dt1970.setTime_t(0);
	dtNow = dtNow.currentDateTime();
	setLastEvent(dt1970.secsTo(dtNow));
}	

bool FileGroupExt::missedScheduleEvent(){
	bool b = false;
	QDateTime dt1970;
	dt1970.setTime_t(0);

	QDateTime dtLastSchedEvent;
	dtLastSchedEvent = schedule() -> lastEvent();

	QDateTime dtLastEvent;
	dtLastEvent.setTime_t( lastEvent());

	int sec1 = dt1970.secsTo(dtLastSchedEvent);
	int sec2 = lastEvent();
	int diff = sec1 - sec2;

	
	if (diff >= 60)
		b = true;
	return b;
}
