/***************************************************************************
                          udg.h  -  description
                             -------------------
    begin                : Thu Dec 23 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UDG_H
#define UDG_H

#include <qfile.h>
#include <qregexp.h>
#include <qtextstream.h>
#include <ksimpleconfig.h>
#include "filegroupext.h"

/**
  *@author Arjan Buursink
  */

class UDG : public FileGroupExt  {
public:
	UDG(QString);
	~UDG();
	/**
	* Sets the dir of a file belonging to the group. Eg. "/tmp" is the dir of a temporary file.
	*/
	void setDir(QString s);
	QString dir() {return dr;};
	/**
	* Sets the pattern of a file belonging to the group. Eg. "*.o" is the pattern of a object file.
	*/
	void addPattern(QString s) {plist -> append(new QRegExp(s,true,true));};
	QList<QRegExp> * patternList() {return plist;};
	/**
	 * Loads a group from disk with filename filename.
	 */
	void load();
	void loadConfig();
	void loadFiles();
	/**
	 * Saves the group to disk.
	 */
	void save();
	void saveFiles();
	void saveConfig();
	/**
	* Tries to add a file to the group. Returns true if succesfull else false.
	*/
	bool tryFile(QString);
	ABProcess * unInstall();
	void clearPatternList(){plist -> clear();};
	QString archiveRoot();
private:
	QList<QRegExp> * plist;
	void strListToPatternList(QStrList);
	QStrList patternListToStrList();
	QString dr;
};

#endif
