/***************************************************************************
                          udgeditordialog.cpp  -  description
                             -------------------
    begin                : Sat Feb 10 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtooltip.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "udgeditordialog.h"
#include "abicondialog.h"
#include "stringdialog.h"

UDGEditorDialog::UDGEditorDialog(UDG * u) : UDGEditorBase(0,"",true){
	udg = u;
	schedule = new Schedule();
	udgToEditor();
}

UDGEditorDialog::~UDGEditorDialog(){
	delete schedule;
}

void UDGEditorDialog::udgToEditor(){
	LineEdit1 -> setText(udg -> name());
	MultiLineEdit1 -> setText(udg -> description());
	KIconLoader l;
	PushButton1 -> setPixmap(l.loadIcon(udg -> icon(), KIcon::Small));
	icon = udg -> icon();
	
	for (unsigned int i = 0; i < udg -> patternList() -> count(); i++)
		ListBox1 -> insertItem(udg -> patternList() -> at(i) -> pattern());
	LineEdit2 -> setText(udg -> dir());
	
	ListView1 -> clear();
	for (unsigned int i = 0; i < udg -> permanent -> count(); i++){
		QFileInfo f(udg -> permanent -> at(i));
		new QListViewItem(ListView1, f.fileName(), f.dirPath());
	}
	
	SpinBox1 -> setValue(udg -> safetyLevel());
	SpinBox2 -> setValue(udg -> maxArchives());
	LineEdit3 -> setText(udg -> command());
	
	CheckBox1 -> setChecked(udg -> scheduleEnabled());
	ComboBox1 -> setCurrentItem(udg -> getAction());
	setSchedule();
	scheduleToWidget();
	slotEnable();
}

void UDGEditorDialog::slotBrowseIcon(){
	ABIconDialog d;
	d.exec();
	KIconLoader l;
	if (d.icon()){
		PushButton1 -> setPixmap(l.loadIcon(d.icon(), KIcon::Small));
		icon = d.icon();
	}
}

void UDGEditorDialog::slotAddPattern(){
	StringDialog d;
	d.setCaption(i18n("Enter pattern"));
	d.exec();
	if (d.string().length() > 0)
		ListBox1 -> insertItem (d.string());
}

void UDGEditorDialog::slotRemovePattern(){
	emptyGroup = true;
	ListBox1 -> removeItem(ListBox1 -> currentItem());
}

void UDGEditorDialog::slotBrowse(){
	LineEdit2 -> setText(KFileDialog::getExistingDirectory(getenv("HOME")));
}

void UDGEditorDialog::slotAddFile(){
	if (dir.isEmpty())
		dir = getenv("HOME");
	QString s(KFileDialog::getOpenFileName(dir));
	if (s != 0L){
		QFileInfo f(s);
		dir  = f.filePath();
		new QListViewItem(ListView1, f.fileName(), f.dirPath());
		emptyGroup = true;
	}
}

void UDGEditorDialog::slotClear(){
	emptyGroup = true;
	ListView1 -> clear();
}

void UDGEditorDialog::slotAddSchedule(){
	if (RadioButton4 -> isChecked()){
		QString s(SpinBox3 -> text());
		int i = s.toInt();
		if (!CheckBox2 -> isChecked()){
			if (schedule -> inDayList(i))
				schedule -> delDay(i);
			else
				schedule -> addDay(i);
		}
		if (CheckBox2 -> isChecked()){
			if (schedule -> dayCycle() == i)
				schedule -> setDayCycle( 0);
			else
				schedule -> setDayCycle(i);
		}
	}
	if (RadioButton5 -> isChecked()){
		QString s(SpinBox4 -> text());
		int i = s.toInt();
		if (!CheckBox3 -> isChecked()){
			if (schedule -> inHourList(i))
				schedule -> delHour(i);
			else
				schedule -> addHour(i);
		}
		if (CheckBox3 -> isChecked()){
			if (schedule -> hourCycle() == i)
				schedule -> setHourCycle( 0);
			else
				schedule -> setHourCycle(i);
		}
	}
	if (RadioButton6 -> isChecked()){
		QString s(SpinBox5 -> text());
		int i = s.toInt();
		if (!CheckBox4 -> isChecked()){
			if (schedule -> inMinuteList(i))
				schedule -> delMinute(i);
			else
				schedule -> addMinute(i);
		}
		if (CheckBox4 -> isChecked()){
			if (schedule -> minuteCycle() == i)
				schedule -> setMinuteCycle( 0);
			else
				schedule -> setMinuteCycle(i);
		}
	}
	scheduleToWidget();
}

void UDGEditorDialog::slotClearSchedule(){
	if (RadioButton4 -> isChecked()){
		schedule -> clearDayList();
		schedule -> setDayCycle(0);
	}
	if (RadioButton5 -> isChecked()){
		schedule -> clearHourList();
		schedule -> setHourCycle(0);
	}
	if (RadioButton6 -> isChecked()){
		schedule -> clearMinuteList();
		schedule -> setMinuteCycle(0);
	}
	scheduleToWidget();
}

void UDGEditorDialog::slotEnable(){
	bool b;
	if (CheckBox1 -> isChecked())
		b = true;
	else
		b = false;
	ComboBox1 -> setEnabled(b);
	RadioButton4 -> setEnabled(b);
	RadioButton5 -> setEnabled(b);
	RadioButton6 -> setEnabled(b);
	CheckBox2 -> setEnabled(b);
	CheckBox3 -> setEnabled(b);
	CheckBox4 -> setEnabled(b);
	SpinBox3 -> setEnabled(b);
	SpinBox4 -> setEnabled(b);
	SpinBox5 -> setEnabled(b);
	PushButton7 -> setEnabled(b);
	PushButton8 -> setEnabled(b);
}

QString UDGEditorDialog::scheduleError(){
	QString s;
	s = QString::null;
	if (CheckBox1 -> isChecked()){
		if (schedule -> dayList().count() == 0 & schedule -> dayCycle() == 0 )
			s = i18n("The day list is empty. Add one or more days");
		if (schedule -> hourList().count() == 0 & schedule -> hourCycle() == 0)
			s = i18n("The hour list is empty. Add one or more hours");
		if (schedule -> minuteList().count() == 0 & schedule -> minuteCycle() == 0)
			s = i18n("The minute list is empty. Add one or more minutes");
	}
	return s;
}

void UDGEditorDialog::setSchedule(){
	schedule -> setDayList(udg -> schedule() -> dayList());
	schedule -> setHourList(udg -> schedule() -> hourList());
	schedule -> setMinuteList(udg -> schedule() -> minuteList());
	schedule -> setDayCycle(udg -> schedule() -> dayCycle());
	schedule -> setHourCycle(udg -> schedule() -> hourCycle());
	schedule -> setMinuteCycle(udg -> schedule() -> minuteCycle());
}

void UDGEditorDialog::slotCheckBox3(){
	RadioButton4 -> setChecked(true);
}

void UDGEditorDialog::slotCheckBox4(){
	RadioButton5 -> setChecked(true);
}

void UDGEditorDialog::slotCheckBox5(){
	RadioButton6 -> setChecked(true);
}


void UDGEditorDialog::scheduleToWidget(){
	QString d,n;
	TextLabel13 -> setText("");
	TextLabel14 -> setText("");
	TextLabel15 -> setText("");
	if (schedule -> dayCycle() != 0){
		n.setNum(schedule -> dayCycle());
		d += "every " + n;
		if (schedule -> dayList().count() > 0)
			d += ", ";
	}
	for (unsigned int i = 0; i < schedule -> dayList().count(); i++){
		n.setNum(*schedule -> dayList().at(i));
		if ( i > 0)
			d += ", ";
		d += n;
	}
	TextLabel13 -> setText(d);
	QToolTip::add(TextLabel13, d);
	d = n = "";
	if (schedule -> hourCycle() != 0){
		n.setNum(schedule -> hourCycle());
		d += "every " + n;
		if (schedule -> hourList().count() > 0)
			d += ", ";
	}
	for (unsigned int i = 0; i < schedule -> hourList().count(); i++){
		n.setNum(*schedule -> hourList().at(i));
		if ( i > 0)
			d += ", ";
		d += n;
	}
	TextLabel14 -> setText(d);
	QToolTip::add(TextLabel14, d);
	d = n = "";
	if (schedule -> minuteCycle() != 0){
		n.setNum(schedule -> minuteCycle());
		d += "every " + n;
		if (schedule -> minuteList().count() > 0)
			d += ", ";
	}
	for (unsigned int i = 0; i < schedule -> minuteList().count(); i++){
		n.setNum(*schedule -> minuteList().at(i));
		if ( i > 0)
			d += ", ";
		d += n;
	}
	TextLabel15 -> setText(d);
	QToolTip::add(TextLabel15, d);
}

void UDGEditorDialog::reject(){
	done(1);
}

void UDGEditorDialog::accept(){
	bool error = false;
	if (scheduleError()){
		KMessageBox::information(0,scheduleError());
		error = true;
	}
	if (!error){
		udg -> setName(LineEdit1 -> text());
		udg -> setDescription(MultiLineEdit1 -> text());
		udg -> setIcon(icon);
		
		udg -> clearPatternList();
		for (unsigned int i = 0; i < ListBox1 -> count(); i++)
			udg -> addPattern(ListBox1 -> text(i));
		udg -> setDir(LineEdit2 -> text());
		if (emptyGroup)
			udg -> empty();
			
		QListViewItem * item = ListView1 -> firstChild();
		udg -> permanent -> clear();
		while (item != 0L){
			QString s(item -> text(1));
			s += "/";
			s += item -> text(0);
			udg -> permanent -> append(s);
			item = item -> nextSibling();
		}		
		
		udg -> setSafetyLevel(SpinBox1 -> text().toInt());
		udg -> setMaxArchives(SpinBox2 -> text().toInt());
		udg -> setCommand(LineEdit3 -> text());
		
		udg -> schedule() -> setDayCycle (schedule -> dayCycle());
		udg -> schedule() -> setHourCycle (schedule -> hourCycle());
		udg -> schedule() -> setMinuteCycle (schedule -> minuteCycle());
		udg -> schedule() -> setDayList (schedule -> dayList());
		udg -> schedule() -> setHourList (schedule -> hourList());
		udg -> schedule() -> setMinuteList (schedule -> minuteList());
		udg -> setScheduleEnabled( CheckBox1 -> isChecked());
		udg -> setAction((action)ComboBox1 -> currentItem());
		
		udg -> sync();
		
		done(0);
	}
}

